/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = 138833868551861343L;
    private final long stateSize;
    private final long alignmentBuffered;
    private final SubtaskStateStats latestAcknowledgedSubtask;
    @Nullable
    private final String externalPath;
    private volatile boolean discarded;

    CompletedCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, int numAcknowledgedSubtasks, long stateSize, long alignmentBuffered, SubtaskStateStats latestAcknowledgedSubtask, @Nullable String externalPath) {
        super(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats);
        Preconditions.checkArgument((numAcknowledgedSubtasks == totalSubtaskCount ? 1 : 0) != 0, (Object)"Did not acknowledge all subtasks.");
        Preconditions.checkArgument((stateSize >= 0L ? 1 : 0) != 0, (Object)"Negative state size");
        this.stateSize = stateSize;
        this.alignmentBuffered = alignmentBuffered;
        this.latestAcknowledgedSubtask = (SubtaskStateStats)Preconditions.checkNotNull((Object)latestAcknowledgedSubtask);
        this.externalPath = externalPath;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.COMPLETED;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.numberOfSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public long getAlignmentBuffered() {
        return this.alignmentBuffered;
    }

    @Override
    @Nullable
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    @Nullable
    public String getExternalPath() {
        return this.externalPath;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    DiscardCallback getDiscardCallback() {
        return new DiscardCallback();
    }

    public String toString() {
        return "CompletedCheckpoint(id=" + this.getCheckpointId() + ")";
    }

    class DiscardCallback {
        DiscardCallback() {
        }

        void notifyDiscardedCheckpoint() {
            CompletedCheckpointStats.this.discarded = true;
        }
    }
}

