/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedStateRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SharedStateRegistry.class);
    private final Map<SharedStateRegistryKey, SharedStateEntry> registeredStates = new HashMap<SharedStateRegistryKey, SharedStateEntry>();
    private final Executor asyncDisposalExecutor;

    public SharedStateRegistry() {
        this(Executors.directExecutor());
    }

    public SharedStateRegistry(Executor asyncDisposalExecutor) {
        this.asyncDisposalExecutor = (Executor)Preconditions.checkNotNull((Object)asyncDisposalExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result registerReference(SharedStateRegistryKey registrationKey, StreamStateHandle state) {
        SharedStateEntry entry;
        Preconditions.checkNotNull((Object)state);
        StreamStateHandle scheduledStateDeletion = null;
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            entry = this.registeredStates.get((Object)registrationKey);
            if (entry == null) {
                entry = new SharedStateEntry(state);
                this.registeredStates.put(registrationKey, entry);
            } else {
                if (!Objects.equals(state, entry.state)) {
                    scheduledStateDeletion = state;
                }
                entry.increaseReferenceCount();
            }
        }
        this.scheduleAsyncDelete(scheduledStateDeletion);
        return new Result(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result unregisterReference(SharedStateRegistryKey registrationKey) {
        Result result;
        StreamStateHandle scheduledStateDeletion;
        Preconditions.checkNotNull((Object)((Object)registrationKey));
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            SharedStateEntry entry = this.registeredStates.get((Object)registrationKey);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (Object)"Cannot unregister a state that is not registered.");
            entry.decreaseReferenceCount();
            if (entry.getReferenceCount() <= 0) {
                this.registeredStates.remove((Object)registrationKey);
                scheduledStateDeletion = entry.getState();
                result = new Result(null, 0);
            } else {
                scheduledStateDeletion = null;
                result = new Result(entry);
            }
        }
        this.scheduleAsyncDelete(scheduledStateDeletion);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll(Iterable<? extends CompositeStateHandle> stateHandles) {
        if (stateHandles == null) {
            return;
        }
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            for (CompositeStateHandle compositeStateHandle : stateHandles) {
                compositeStateHandle.registerSharedStates(this);
            }
        }
    }

    private void scheduleAsyncDelete(StreamStateHandle streamStateHandle) {
        if (streamStateHandle != null && !this.isPlaceholder(streamStateHandle)) {
            this.asyncDisposalExecutor.execute(new AsyncDisposalRunnable(streamStateHandle));
        }
    }

    private boolean isPlaceholder(StreamStateHandle stateHandle) {
        return stateHandle instanceof PlaceholderStreamStateHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<SharedStateRegistryKey, SharedStateEntry> map = this.registeredStates;
        synchronized (map) {
            this.registeredStates.clear();
        }
    }

    private static final class AsyncDisposalRunnable
    implements Runnable {
        private final StateObject toDispose;

        public AsyncDisposalRunnable(StateObject toDispose) {
            this.toDispose = (StateObject)Preconditions.checkNotNull((Object)toDispose);
        }

        @Override
        public void run() {
            try {
                this.toDispose.discardState();
            }
            catch (Exception e) {
                LOG.warn("A problem occurred during asynchronous disposal of a shared state object: {}", (Object)this.toDispose, (Object)e);
            }
        }
    }

    public static class Result {
        private final StreamStateHandle reference;
        private final int referenceCount;

        private Result(SharedStateEntry sharedStateEntry) {
            this.reference = sharedStateEntry.getState();
            this.referenceCount = sharedStateEntry.getReferenceCount();
        }

        public Result(StreamStateHandle reference, int referenceCount) {
            Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0);
            this.reference = reference;
            this.referenceCount = referenceCount;
        }

        public StreamStateHandle getReference() {
            return this.reference;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }
    }

    private static class SharedStateEntry {
        private final StreamStateHandle state;
        private int referenceCount;

        SharedStateEntry(StreamStateHandle value) {
            this.state = value;
            this.referenceCount = 1;
        }

        StreamStateHandle getState() {
            return this.state;
        }

        int getReferenceCount() {
            return this.referenceCount;
        }

        void increaseReferenceCount() {
            ++this.referenceCount;
        }

        void decreaseReferenceCount() {
            --this.referenceCount;
        }
    }
}

