/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalKeyedStateHandle
implements KeyedStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalKeyedStateHandle.class);
    private static final long serialVersionUID = -8328808513197388231L;
    private final String operatorIdentifier;
    private final KeyGroupRange keyGroupRange;
    private final long checkpointId;
    private final Map<StateHandleID, StreamStateHandle> sharedState;
    private final Map<StateHandleID, StreamStateHandle> privateState;
    private final StreamStateHandle metaStateHandle;
    private transient SharedStateRegistry sharedStateRegistry;

    public IncrementalKeyedStateHandle(String operatorIdentifier, KeyGroupRange keyGroupRange, long checkpointId, Map<StateHandleID, StreamStateHandle> sharedState, Map<StateHandleID, StreamStateHandle> privateState, StreamStateHandle metaStateHandle) {
        this.operatorIdentifier = (String)Preconditions.checkNotNull((Object)operatorIdentifier);
        this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
        this.checkpointId = checkpointId;
        this.sharedState = (Map)Preconditions.checkNotNull(sharedState);
        this.privateState = (Map)Preconditions.checkNotNull(privateState);
        this.metaStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)metaStateHandle);
        this.sharedStateRegistry = null;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public Map<StateHandleID, StreamStateHandle> getSharedState() {
        return this.sharedState;
    }

    public Map<StateHandleID, StreamStateHandle> getPrivateState() {
        return this.privateState;
    }

    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    public String getOperatorIdentifier() {
        return this.operatorIdentifier;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        if (this.keyGroupRange.getIntersection(keyGroupRange) != KeyGroupRange.EMPTY_KEY_GROUP_RANGE) {
            return this;
        }
        return null;
    }

    @Override
    public void discardState() throws Exception {
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        try {
            StateUtil.bestEffortDiscardAllStateObjects(this.privateState.values());
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard misc file states.", (Throwable)e);
        }
        if (this.sharedStateRegistry == null) {
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.sharedState.values());
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard new sst file states.", (Throwable)e);
            }
        } else {
            for (StateHandleID stateHandleID : this.sharedState.keySet()) {
                this.sharedStateRegistry.unregisterReference(this.createSharedStateRegistryKeyFromFileName(stateHandleID));
            }
        }
    }

    @Override
    public long getStateSize() {
        long size = StateUtil.getStateSize(this.metaStateHandle);
        for (StreamStateHandle sharedStateHandle : this.sharedState.values()) {
            size += sharedStateHandle.getStateSize();
        }
        for (StreamStateHandle privateStateHandle : this.privateState.values()) {
            size += privateStateHandle.getStateSize();
        }
        return size;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        Preconditions.checkState((this.sharedStateRegistry == null ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        for (Map.Entry<StateHandleID, StreamStateHandle> sharedStateHandle : this.sharedState.entrySet()) {
            SharedStateRegistryKey registryKey = this.createSharedStateRegistryKeyFromFileName(sharedStateHandle.getKey());
            SharedStateRegistry.Result result = stateRegistry.registerReference(registryKey, sharedStateHandle.getValue());
            sharedStateHandle.setValue(result.getReference());
        }
    }

    @VisibleForTesting
    public SharedStateRegistryKey createSharedStateRegistryKeyFromFileName(StateHandleID shId) {
        return new SharedStateRegistryKey(this.operatorIdentifier + '-' + this.keyGroupRange, shId);
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalKeyedStateHandle that = (IncrementalKeyedStateHandle)o;
        if (this.getCheckpointId() != that.getCheckpointId()) {
            return false;
        }
        if (!this.getOperatorIdentifier().equals(that.getOperatorIdentifier())) {
            return false;
        }
        if (!this.getKeyGroupRange().equals(that.getKeyGroupRange())) {
            return false;
        }
        if (!this.getSharedState().equals(that.getSharedState())) {
            return false;
        }
        if (!this.getPrivateState().equals(that.getPrivateState())) {
            return false;
        }
        return this.getMetaStateHandle().equals(that.getMetaStateHandle());
    }

    @VisibleForTesting
    public int hashCode() {
        int result = this.getOperatorIdentifier().hashCode();
        result = 31 * result + this.getKeyGroupRange().hashCode();
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + this.getSharedState().hashCode();
        result = 31 * result + this.getPrivateState().hashCode();
        result = 31 * result + this.getMetaStateHandle().hashCode();
        return result;
    }
}

