/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KerberosUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosUtils.class);
    private static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
    private static final boolean IBM_JAVA;
    private static final Map<String, String> debugOptions;
    private static final Map<String, String> kerberosCacheOptions;
    private static final AppConfigurationEntry userKerberosAce;

    public static AppConfigurationEntry ticketCacheEntry() {
        return userKerberosAce;
    }

    public static AppConfigurationEntry keytabEntry(String keytab, String principal) {
        Preconditions.checkNotNull((Object)keytab, (String)"keytab");
        Preconditions.checkNotNull((Object)principal, (String)"principal");
        HashMap<String, String> keytabKerberosOptions = new HashMap<String, String>();
        if (IBM_JAVA) {
            keytabKerberosOptions.put("useKeytab", KerberosUtils.prependFileUri(keytab));
            keytabKerberosOptions.put("credsType", "both");
        } else {
            keytabKerberosOptions.put("keyTab", keytab);
            keytabKerberosOptions.put("doNotPrompt", "true");
            keytabKerberosOptions.put("useKeyTab", "true");
            keytabKerberosOptions.put("storeKey", "true");
        }
        keytabKerberosOptions.put("principal", principal);
        keytabKerberosOptions.put("refreshKrb5Config", "true");
        keytabKerberosOptions.putAll(debugOptions);
        AppConfigurationEntry keytabKerberosAce = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, keytabKerberosOptions);
        return keytabKerberosAce;
    }

    private static String prependFileUri(String keytabPath) {
        File f = new File(keytabPath);
        return f.toURI().toString();
    }

    static {
        debugOptions = new HashMap<String, String>();
        kerberosCacheOptions = new HashMap<String, String>();
        IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");
        if (LOG.isDebugEnabled()) {
            debugOptions.put("debug", "true");
        }
        if (IBM_JAVA) {
            kerberosCacheOptions.put("useDefaultCcache", "true");
        } else {
            kerberosCacheOptions.put("doNotPrompt", "true");
            kerberosCacheOptions.put("useTicketCache", "true");
        }
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            if (IBM_JAVA) {
                System.setProperty("KRB5CCNAME", ticketCache);
            } else {
                kerberosCacheOptions.put("ticketCache", ticketCache);
            }
        }
        kerberosCacheOptions.put("renewTGT", "true");
        kerberosCacheOptions.putAll(debugOptions);
        userKerberosAce = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, kerberosCacheOptions);
    }
}

