/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.exceptions;

import java.util.UUID;
import org.apache.flink.util.Preconditions;

public class LeaderSessionIDException
extends Exception {
    private static final long serialVersionUID = -3276145308053264636L;
    private final UUID expectedLeaderSessionID;
    private final UUID actualLeaderSessionID;

    public LeaderSessionIDException(UUID expectedLeaderSessionID, UUID actualLeaderSessionID) {
        super("Unmatched leader session ID : expected " + expectedLeaderSessionID + ", actual " + actualLeaderSessionID);
        this.expectedLeaderSessionID = (UUID)Preconditions.checkNotNull((Object)expectedLeaderSessionID);
        this.actualLeaderSessionID = (UUID)Preconditions.checkNotNull((Object)actualLeaderSessionID);
    }

    public UUID getExpectedLeaderSessionID() {
        return this.expectedLeaderSessionID;
    }

    public UUID getActualLeaderSessionID() {
        return this.actualLeaderSessionID;
    }
}

