/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.runtime.concurrent.ApplyFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public abstract class RegisteredRpcConnection<Gateway extends RpcGateway, Success extends RegistrationResponse.Success> {
    protected final Logger log;
    private final UUID targetLeaderId;
    private final String targetAddress;
    private final Executor executor;
    private RetryingRegistration<Gateway, Success> pendingRegistration;
    private volatile Gateway targetGateway;
    private volatile boolean closed;

    public RegisteredRpcConnection(Logger log, String targetAddress, UUID targetLeaderId, Executor executor) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.targetLeaderId = (UUID)Preconditions.checkNotNull((Object)targetLeaderId);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public void start() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"The RPC connection is already closed");
        Preconditions.checkState((!this.isConnected() && this.pendingRegistration == null ? 1 : 0) != 0, (Object)"The RPC connection is already started");
        this.pendingRegistration = (RetryingRegistration)Preconditions.checkNotNull(this.generateRegistration());
        this.pendingRegistration.startRegistration();
        Future<Tuple2<Gateway, Success>> future = this.pendingRegistration.getFuture();
        Future<Void> registrationSuccessFuture = future.thenAcceptAsync(new AcceptFunction<Tuple2<Gateway, Success>>(){

            @Override
            public void accept(Tuple2<Gateway, Success> result) {
                RegisteredRpcConnection.this.targetGateway = (RpcGateway)result.f0;
                RegisteredRpcConnection.this.onRegistrationSuccess((RegistrationResponse.Success)result.f1);
            }
        }, this.executor);
        registrationSuccessFuture.exceptionallyAsync(new ApplyFunction<Throwable, Void>(){

            @Override
            public Void apply(Throwable failure) {
                RegisteredRpcConnection.this.onRegistrationFailure(failure);
                return null;
            }
        }, this.executor);
    }

    protected abstract RetryingRegistration<Gateway, Success> generateRegistration();

    protected abstract void onRegistrationSuccess(Success var1);

    protected abstract void onRegistrationFailure(Throwable var1);

    public void close() {
        this.closed = true;
        if (this.pendingRegistration != null) {
            this.pendingRegistration.cancel();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UUID getTargetLeaderId() {
        return this.targetLeaderId;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public Gateway getTargetGateway() {
        return this.targetGateway;
    }

    public boolean isConnected() {
        return this.targetGateway != null;
    }

    public String toString() {
        String connectionInfo = "(ADDRESS: " + this.targetAddress + " LEADERID: " + this.targetLeaderId + ")";
        connectionInfo = this.isConnected() ? "RPC connection to " + this.targetGateway.getClass().getSimpleName() + " " + connectionInfo : "RPC connection to " + connectionInfo;
        connectionInfo = this.isClosed() ? connectionInfo + " is closed" : (this.isConnected() ? connectionInfo + " is established" : connectionInfo + " is connecting");
        return connectionInfo;
    }
}

