/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.util.SerializedValue;

public class JobCheckpointingSettings
implements Serializable {
    private static final long serialVersionUID = -2593319571078198180L;
    private final List<JobVertexID> verticesToTrigger;
    private final List<JobVertexID> verticesToAcknowledge;
    private final List<JobVertexID> verticesToConfirm;
    private final long checkpointInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpoints;
    private final ExternalizedCheckpointSettings externalizedCheckpointSettings;
    @Nullable
    private final StateBackend defaultStateBackend;
    @Nullable
    private final SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks;
    private final boolean isExactlyOnce;

    public JobCheckpointingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, ExternalizedCheckpointSettings externalizedCheckpointSettings, @Nullable StateBackend defaultStateBackend, boolean isExactlyOnce) {
        this(verticesToTrigger, verticesToAcknowledge, verticesToConfirm, checkpointInterval, checkpointTimeout, minPauseBetweenCheckpoints, maxConcurrentCheckpoints, externalizedCheckpointSettings, defaultStateBackend, null, isExactlyOnce);
    }

    public JobCheckpointingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, ExternalizedCheckpointSettings externalizedCheckpointSettings, @Nullable StateBackend defaultStateBackend, @Nullable SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks, boolean isExactlyOnce) {
        if (checkpointInterval < 1L || checkpointTimeout < 1L || minPauseBetweenCheckpoints < 0L || maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException();
        }
        this.verticesToTrigger = Objects.requireNonNull(verticesToTrigger);
        this.verticesToAcknowledge = Objects.requireNonNull(verticesToAcknowledge);
        this.verticesToConfirm = Objects.requireNonNull(verticesToConfirm);
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.externalizedCheckpointSettings = Objects.requireNonNull(externalizedCheckpointSettings);
        this.defaultStateBackend = defaultStateBackend;
        this.isExactlyOnce = isExactlyOnce;
        this.masterHooks = masterHooks;
    }

    public List<JobVertexID> getVerticesToTrigger() {
        return this.verticesToTrigger;
    }

    public List<JobVertexID> getVerticesToAcknowledge() {
        return this.verticesToAcknowledge;
    }

    public List<JobVertexID> getVerticesToConfirm() {
        return this.verticesToConfirm;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public ExternalizedCheckpointSettings getExternalizedCheckpointSettings() {
        return this.externalizedCheckpointSettings;
    }

    @Nullable
    public StateBackend getDefaultStateBackend() {
        return this.defaultStateBackend;
    }

    @Nullable
    public SerializedValue<MasterTriggerRestoreHook.Factory[]> getMasterHooks() {
        return this.masterHooks;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public String toString() {
        return String.format("SnapshotSettings: interval=%d, timeout=%d, pause-between=%d, maxConcurrent=%d, trigger=%s, ack=%s, commit=%s", this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.verticesToTrigger, this.verticesToAcknowledge, this.verticesToConfirm);
    }
}

