/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.metrics.Meter;

public class IOMetrics
implements Serializable {
    private static final long serialVersionUID = -7208093607556457183L;
    protected long numRecordsIn;
    protected long numRecordsOut;
    protected double numRecordsInPerSecond;
    protected double numRecordsOutPerSecond;
    protected long numBytesInLocal;
    protected long numBytesInRemote;
    protected long numBytesOut;
    protected double numBytesInLocalPerSecond;
    protected double numBytesInRemotePerSecond;
    protected double numBytesOutPerSecond;

    public IOMetrics(Meter recordsIn, Meter recordsOut, Meter bytesLocalIn, Meter bytesRemoteIn, Meter bytesOut) {
        this.numRecordsIn = recordsIn.getCount();
        this.numRecordsInPerSecond = recordsIn.getRate();
        this.numRecordsOut = recordsOut.getCount();
        this.numRecordsOutPerSecond = recordsOut.getRate();
        this.numBytesInLocal = bytesLocalIn.getCount();
        this.numBytesInLocalPerSecond = bytesLocalIn.getRate();
        this.numBytesInRemote = bytesRemoteIn.getCount();
        this.numBytesInRemotePerSecond = bytesRemoteIn.getRate();
        this.numBytesOut = bytesOut.getCount();
        this.numBytesOutPerSecond = bytesOut.getRate();
    }

    public IOMetrics(int numBytesInLocal, int numBytesInRemote, int numBytesOut, int numRecordsIn, int numRecordsOut, double numBytesInLocalPerSecond, double numBytesInRemotePerSecond, double numBytesOutPerSecond, double numRecordsInPerSecond, double numRecordsOutPerSecond) {
        this.numBytesInLocal = numBytesInLocal;
        this.numBytesInRemote = numBytesInRemote;
        this.numBytesOut = numBytesOut;
        this.numRecordsIn = numRecordsIn;
        this.numRecordsOut = numRecordsOut;
        this.numBytesInLocalPerSecond = numBytesInLocalPerSecond;
        this.numBytesInRemotePerSecond = numBytesInRemotePerSecond;
        this.numBytesOutPerSecond = numBytesOutPerSecond;
        this.numRecordsInPerSecond = numRecordsInPerSecond;
        this.numRecordsOutPerSecond = numRecordsOutPerSecond;
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public long getNumBytesInLocal() {
        return this.numBytesInLocal;
    }

    public long getNumBytesInRemote() {
        return this.numBytesInRemote;
    }

    public long getNumBytesInTotal() {
        return this.numBytesInLocal + this.numBytesInRemote;
    }

    public long getNumBytesOut() {
        return this.numBytesOut;
    }

    public double getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public double getNumRecordsOutPerSecond() {
        return this.numRecordsOutPerSecond;
    }

    public double getNumBytesInLocalPerSecond() {
        return this.numBytesInLocalPerSecond;
    }

    public double getNumBytesInRemotePerSecond() {
        return this.numBytesInRemotePerSecond;
    }

    public double getNumBytesOutPerSecond() {
        return this.numBytesOutPerSecond;
    }
}

