/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.StoppingException;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.runtime.concurrent.BiFunction;
import org.apache.flink.runtime.concurrent.CompletableFuture;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AllVerticesIterator;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAndSlot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.ExecutionGraphUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionStatusListener;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.util.SerializedThrowable;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionGraph
implements AccessExecutionGraph,
Archiveable<ArchivedExecutionGraph> {
    private static final AtomicReferenceFieldUpdater<ExecutionGraph, JobStatus> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExecutionGraph.class, JobStatus.class, "state");
    private static final AtomicLongFieldUpdater<ExecutionGraph> GLOBAL_VERSION_UPDATER = AtomicLongFieldUpdater.newUpdater(ExecutionGraph.class, "globalModVersion");
    static final Logger LOG = LoggerFactory.getLogger(ExecutionGraph.class);
    private final Object progressLock = new Object();
    private final JobInformation jobInformation;
    private final SerializedValue<JobInformation> serializedJobInformation;
    private final ScheduledExecutorService futureExecutor;
    private final Executor ioExecutor;
    private boolean isStoppable = true;
    private final ConcurrentHashMap<JobVertexID, ExecutionJobVertex> tasks;
    private final List<ExecutionJobVertex> verticesInCreationOrder;
    private final ConcurrentHashMap<IntermediateDataSetID, IntermediateResult> intermediateResults;
    private final ConcurrentHashMap<ExecutionAttemptID, Execution> currentExecutions;
    private final List<JobStatusListener> jobStatusListeners;
    private final List<ExecutionStatusListener> executionListeners;
    private final FailoverStrategy failoverStrategy;
    private final long[] stateTimestamps;
    private final Time rpcCallTimeout;
    private final Time scheduleAllocationTimeout;
    private final RestartStrategy restartStrategy;
    private final SlotProvider slotProvider;
    private final ClassLoader userClassLoader;
    private final KvStateLocationRegistry kvStateLocationRegistry;
    private int numVerticesTotal;
    private boolean allowQueuedScheduling = false;
    private ScheduleMode scheduleMode = ScheduleMode.LAZY_FROM_SOURCES;
    private final AtomicInteger verticesFinished;
    private volatile JobStatus state = JobStatus.CREATED;
    private volatile CompletableFuture<JobStatus> terminationFuture;
    private volatile long globalModVersion;
    private volatile Throwable failureCause;
    private CheckpointCoordinator checkpointCoordinator;
    private CheckpointStatsTracker checkpointStatsTracker;
    private String jsonPlan;

    @VisibleForTesting
    ExecutionGraph(ScheduledExecutorService futureExecutor, Executor ioExecutor, JobID jobId, String jobName, Configuration jobConfig, SerializedValue<ExecutionConfig> serializedConfig, Time timeout, RestartStrategy restartStrategy, SlotProvider slotProvider) {
        this(futureExecutor, ioExecutor, jobId, jobName, jobConfig, serializedConfig, timeout, restartStrategy, new RestartAllStrategy.Factory(), Collections.emptyList(), Collections.emptyList(), slotProvider, ExecutionGraph.class.getClassLoader());
    }

    public ExecutionGraph(ScheduledExecutorService futureExecutor, Executor ioExecutor, JobID jobId, String jobName, Configuration jobConfig, SerializedValue<ExecutionConfig> serializedConfig, Time timeout, RestartStrategy restartStrategy, FailoverStrategy.Factory failoverStrategyFactory, List<BlobKey> requiredJarFiles, List<URL> requiredClasspaths, SlotProvider slotProvider, ClassLoader userClassLoader) {
        Preconditions.checkNotNull((Object)futureExecutor);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)jobName);
        Preconditions.checkNotNull((Object)jobConfig);
        this.jobInformation = new JobInformation(jobId, jobName, serializedConfig, jobConfig, requiredJarFiles, requiredClasspaths);
        try {
            this.serializedJobInformation = new SerializedValue((Object)this.jobInformation);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Bug: Cannot serialize JobInformation", (Throwable)e);
        }
        this.futureExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)futureExecutor);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.slotProvider = (SlotProvider)Preconditions.checkNotNull((Object)slotProvider, (String)"scheduler");
        this.userClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userClassLoader, (String)"userClassLoader");
        this.tasks = new ConcurrentHashMap(16);
        this.intermediateResults = new ConcurrentHashMap(16);
        this.verticesInCreationOrder = new ArrayList<ExecutionJobVertex>(16);
        this.currentExecutions = new ConcurrentHashMap(16);
        this.jobStatusListeners = new CopyOnWriteArrayList<JobStatusListener>();
        this.executionListeners = new CopyOnWriteArrayList<ExecutionStatusListener>();
        this.stateTimestamps = new long[JobStatus.values().length];
        this.stateTimestamps[JobStatus.CREATED.ordinal()] = System.currentTimeMillis();
        this.rpcCallTimeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.scheduleAllocationTimeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.restartStrategy = restartStrategy;
        this.kvStateLocationRegistry = new KvStateLocationRegistry(jobId, this.getAllVertices());
        this.verticesFinished = new AtomicInteger();
        this.globalModVersion = 1L;
        this.failoverStrategy = (FailoverStrategy)Preconditions.checkNotNull((Object)failoverStrategyFactory.create(this), (String)"null failover strategy");
        LOG.info("Job recovers via failover strategy: {}", (Object)this.failoverStrategy.getStrategyName());
    }

    public int getNumberOfExecutionJobVertices() {
        return this.verticesInCreationOrder.size();
    }

    public boolean isQueuedSchedulingAllowed() {
        return this.allowQueuedScheduling;
    }

    public void setQueuedSchedulingAllowed(boolean allowed) {
        this.allowQueuedScheduling = allowed;
    }

    public void setScheduleMode(ScheduleMode scheduleMode) {
        this.scheduleMode = scheduleMode;
    }

    public ScheduleMode getScheduleMode() {
        return this.scheduleMode;
    }

    @Override
    public boolean isArchived() {
        return false;
    }

    public void enableCheckpointing(long interval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, ExternalizedCheckpointSettings externalizeSettings, List<ExecutionJobVertex> verticesToTrigger, List<ExecutionJobVertex> verticesToWaitFor, List<ExecutionJobVertex> verticesToCommitTo, List<MasterTriggerRestoreHook<?>> masterHooks, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore checkpointStore, String checkpointDir, StateBackend metadataStore, CheckpointStatsTracker statsTracker) {
        Preconditions.checkArgument((interval >= 10L ? 1 : 0) != 0, (Object)"checkpoint interval must not be below 10ms");
        Preconditions.checkArgument((checkpointTimeout >= 10L ? 1 : 0) != 0, (Object)"checkpoint timeout must not be below 10ms");
        Preconditions.checkState((this.state == JobStatus.CREATED ? 1 : 0) != 0, (Object)"Job must be in CREATED state");
        Preconditions.checkState((this.checkpointCoordinator == null ? 1 : 0) != 0, (Object)"checkpointing already enabled");
        ExecutionVertex[] tasksToTrigger = this.collectExecutionVertices(verticesToTrigger);
        ExecutionVertex[] tasksToWaitFor = this.collectExecutionVertices(verticesToWaitFor);
        ExecutionVertex[] tasksToCommitTo = this.collectExecutionVertices(verticesToCommitTo);
        this.checkpointStatsTracker = (CheckpointStatsTracker)Preconditions.checkNotNull((Object)statsTracker, (String)"CheckpointStatsTracker");
        this.checkpointCoordinator = new CheckpointCoordinator(this.jobInformation.getJobId(), interval, checkpointTimeout, minPauseBetweenCheckpoints, maxConcurrentCheckpoints, externalizeSettings, tasksToTrigger, tasksToWaitFor, tasksToCommitTo, checkpointIDCounter, checkpointStore, checkpointDir, this.ioExecutor);
        for (MasterTriggerRestoreHook<?> hook : masterHooks) {
            if (this.checkpointCoordinator.addMasterHook(hook)) continue;
            LOG.warn("Trying to register multiple checkpoint hooks with the name: {}", (Object)hook.getIdentifier());
        }
        this.checkpointCoordinator.setCheckpointStatsTracker(this.checkpointStatsTracker);
        if (interval != Long.MAX_VALUE) {
            this.registerJobStatusListener(this.checkpointCoordinator.createActivatorDeactivator());
        }
    }

    @Override
    public CheckpointCoordinator getCheckpointCoordinator() {
        return this.checkpointCoordinator;
    }

    public KvStateLocationRegistry getKvStateLocationRegistry() {
        return this.kvStateLocationRegistry;
    }

    public RestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    @Override
    public JobCheckpointingSettings getJobCheckpointingSettings() {
        if (this.checkpointStatsTracker != null) {
            return this.checkpointStatsTracker.getSnapshottingSettings();
        }
        return null;
    }

    @Override
    public CheckpointStatsSnapshot getCheckpointStatsSnapshot() {
        if (this.checkpointStatsTracker != null) {
            return this.checkpointStatsTracker.createSnapshot();
        }
        return null;
    }

    private ExecutionVertex[] collectExecutionVertices(List<ExecutionJobVertex> jobVertices) {
        if (jobVertices.size() == 1) {
            ExecutionJobVertex jv = jobVertices.get(0);
            if (jv.getGraph() != this) {
                throw new IllegalArgumentException("Can only use ExecutionJobVertices of this ExecutionGraph");
            }
            return jv.getTaskVertices();
        }
        ArrayList<ExecutionVertex> all = new ArrayList<ExecutionVertex>();
        for (ExecutionJobVertex jv : jobVertices) {
            if (jv.getGraph() != this) {
                throw new IllegalArgumentException("Can only use ExecutionJobVertices of this ExecutionGraph");
            }
            all.addAll(Arrays.asList(jv.getTaskVertices()));
        }
        return all.toArray(new ExecutionVertex[all.size()]);
    }

    public Collection<BlobKey> getRequiredJarFiles() {
        return this.jobInformation.getRequiredJarFileBlobKeys();
    }

    public Collection<URL> getRequiredClasspaths() {
        return this.jobInformation.getRequiredClasspathURLs();
    }

    public void setJsonPlan(String jsonPlan) {
        this.jsonPlan = jsonPlan;
    }

    @Override
    public String getJsonPlan() {
        return this.jsonPlan;
    }

    public SlotProvider getSlotProvider() {
        return this.slotProvider;
    }

    public SerializedValue<JobInformation> getSerializedJobInformation() {
        return this.serializedJobInformation;
    }

    @Override
    public JobID getJobID() {
        return this.jobInformation.getJobId();
    }

    @Override
    public String getJobName() {
        return this.jobInformation.getJobName();
    }

    @Override
    public boolean isStoppable() {
        return this.isStoppable;
    }

    public Configuration getJobConfiguration() {
        return this.jobInformation.getJobConfiguration();
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public JobStatus getState() {
        return this.state;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public long getNumberOfFullRestarts() {
        return this.globalModVersion - 1L;
    }

    @Override
    public String getFailureCauseAsString() {
        return ExceptionUtils.stringifyException((Throwable)this.failureCause);
    }

    @Override
    public ExecutionJobVertex getJobVertex(JobVertexID id) {
        return this.tasks.get((Object)id);
    }

    public Map<JobVertexID, ExecutionJobVertex> getAllVertices() {
        return Collections.unmodifiableMap(this.tasks);
    }

    public Iterable<ExecutionJobVertex> getVerticesTopologically() {
        final int numElements = this.verticesInCreationOrder.size();
        return new Iterable<ExecutionJobVertex>(){

            @Override
            public Iterator<ExecutionJobVertex> iterator() {
                return new Iterator<ExecutionJobVertex>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < numElements;
                    }

                    @Override
                    public ExecutionJobVertex next() {
                        if (this.hasNext()) {
                            return (ExecutionJobVertex)ExecutionGraph.this.verticesInCreationOrder.get(this.pos++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public int getTotalNumberOfVertices() {
        return this.numVerticesTotal;
    }

    public Map<IntermediateDataSetID, IntermediateResult> getAllIntermediateResults() {
        return Collections.unmodifiableMap(this.intermediateResults);
    }

    public Iterable<ExecutionVertex> getAllExecutionVertices() {
        return new Iterable<ExecutionVertex>(){

            @Override
            public Iterator<ExecutionVertex> iterator() {
                return new AllVerticesIterator(ExecutionGraph.this.getVerticesTopologically().iterator());
            }
        };
    }

    @Override
    public long getStatusTimestamp(JobStatus status) {
        return this.stateTimestamps[status.ordinal()];
    }

    public Executor getFutureExecutor() {
        return this.futureExecutor;
    }

    public Map<String, Accumulator<?, ?>> aggregateUserAccumulators() {
        HashMap userAccumulators = new HashMap();
        for (ExecutionVertex vertex : this.getAllExecutionVertices()) {
            Map<String, Accumulator<?, ?>> next = vertex.getCurrentExecutionAttempt().getUserAccumulators();
            if (next == null) continue;
            AccumulatorHelper.mergeInto(userAccumulators, next);
        }
        return userAccumulators;
    }

    public Map<String, Object> getAccumulators() throws IOException {
        Map<String, Accumulator<?, ?>> accumulatorMap = this.aggregateUserAccumulators();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulatorMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getLocalValue());
        }
        return result;
    }

    @Override
    public Map<String, SerializedValue<Object>> getAccumulatorsSerialized() throws IOException {
        Map<String, Accumulator<?, ?>> accumulatorMap = this.aggregateUserAccumulators();
        HashMap<String, SerializedValue<Object>> result = new HashMap<String, SerializedValue<Object>>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulatorMap.entrySet()) {
            result.put(entry.getKey(), (SerializedValue<Object>)new SerializedValue((Object)entry.getValue().getLocalValue()));
        }
        return result;
    }

    @Override
    public StringifiedAccumulatorResult[] getAccumulatorResultsStringified() {
        Map<String, Accumulator<?, ?>> accumulatorMap = this.aggregateUserAccumulators();
        return StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
    }

    public void attachJobGraph(List<JobVertex> topologiallySorted) throws JobException {
        LOG.debug("Attaching {} topologically sorted vertices to existing job graph with {} vertices and {} intermediate results.", new Object[]{topologiallySorted.size(), this.tasks.size(), this.intermediateResults.size()});
        ArrayList<ExecutionJobVertex> newExecJobVertices = new ArrayList<ExecutionJobVertex>(topologiallySorted.size());
        long createTimestamp = System.currentTimeMillis();
        for (JobVertex jobVertex : topologiallySorted) {
            if (jobVertex.isInputVertex() && !jobVertex.isStoppable()) {
                this.isStoppable = false;
            }
            ExecutionJobVertex ejv = new ExecutionJobVertex(this, jobVertex, 1, this.rpcCallTimeout, this.globalModVersion, createTimestamp);
            ejv.connectToPredecessors(this.intermediateResults);
            ExecutionJobVertex previousTask = this.tasks.putIfAbsent(jobVertex.getID(), ejv);
            if (previousTask != null) {
                throw new JobException(String.format("Encountered two job vertices with ID %s : previous=[%s] / new=[%s]", new Object[]{jobVertex.getID(), ejv, previousTask}));
            }
            for (IntermediateResult res : ejv.getProducedDataSets()) {
                IntermediateResult previousDataSet = this.intermediateResults.putIfAbsent(res.getId(), res);
                if (previousDataSet == null) continue;
                throw new JobException(String.format("Encountered two intermediate data set with ID %s : previous=[%s] / new=[%s]", new Object[]{res.getId(), res, previousDataSet}));
            }
            this.verticesInCreationOrder.add(ejv);
            this.numVerticesTotal += ejv.getParallelism();
            newExecJobVertices.add(ejv);
        }
        this.terminationFuture = new FlinkCompletableFuture<JobStatus>();
        this.failoverStrategy.notifyNewVertices(newExecJobVertices);
    }

    public void scheduleForExecution() throws JobException {
        block5: {
            block4: {
                if (!this.transitionState(JobStatus.CREATED, JobStatus.RUNNING)) break block4;
                switch (this.scheduleMode) {
                    case LAZY_FROM_SOURCES: {
                        this.scheduleLazy(this.slotProvider);
                        break block5;
                    }
                    case EAGER: {
                        this.scheduleEager(this.slotProvider, this.scheduleAllocationTimeout);
                        break block5;
                    }
                    default: {
                        throw new JobException("Schedule mode is invalid.");
                    }
                }
            }
            throw new IllegalStateException("Job may only be scheduled from state " + (Object)((Object)JobStatus.CREATED));
        }
    }

    private void scheduleLazy(SlotProvider slotProvider) throws NoResourceAvailableException {
        for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
            if (!ejv.getJobVertex().isInputVertex()) continue;
            ejv.scheduleAll(slotProvider, this.allowQueuedScheduling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEager(SlotProvider slotProvider, final Time timeout) {
        Preconditions.checkState((this.state == JobStatus.RUNNING ? 1 : 0) != 0, (Object)"job is not running currently");
        final ArrayList<ExecutionAndSlot[]> resources = new ArrayList<ExecutionAndSlot[]>(this.getNumberOfExecutionJobVertices());
        boolean queued = this.allowQueuedScheduling;
        boolean successful = false;
        try {
            ArrayList<Future<SimpleSlot>> slotFutures = new ArrayList<Future<SimpleSlot>>(this.getNumberOfExecutionJobVertices());
            for (ExecutionJobVertex ejv : this.getVerticesTopologically()) {
                ExecutionAndSlot[] slots = ejv.allocateResourcesForAll(slotProvider, queued);
                resources.add(slots);
                for (ExecutionAndSlot ens : slots) {
                    slotFutures.add(ens.slotFuture);
                }
            }
            final FutureUtils.ConjunctFuture<Void> allAllocationsComplete = FutureUtils.waitForAll(slotFutures);
            final ScheduledFuture<?> timeoutCancelHandle = this.futureExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    int numTotal = allAllocationsComplete.getNumFuturesTotal();
                    int numComplete = allAllocationsComplete.getNumFuturesCompleted();
                    String message = "Could not allocate all requires slots within timeout of " + timeout + ". Slots required: " + numTotal + ", slots allocated: " + numComplete;
                    allAllocationsComplete.completeExceptionally(new NoResourceAvailableException(message));
                }
            }, timeout.getSize(), timeout.getUnit());
            allAllocationsComplete.handleAsync(new BiFunction<Void, Throwable, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void apply(Void slots, Throwable throwable) {
                    block10: {
                        try {
                            timeoutCancelHandle.cancel(false);
                            if (throwable == null) {
                                Iterator iterator = resources.iterator();
                                while (iterator.hasNext()) {
                                    ExecutionAndSlot[] jobVertexTasks;
                                    for (ExecutionAndSlot execAndSlot : jobVertexTasks = (ExecutionAndSlot[])iterator.next()) {
                                        SimpleSlot slot;
                                        try {
                                            slot = execAndSlot.slotFuture.getNow(null);
                                            Preconditions.checkNotNull((Object)slot);
                                        }
                                        catch (NullPointerException | ExecutionException e) {
                                            throw new IllegalStateException("SlotFuture is incomplete or erroneous even though all futures completed");
                                        }
                                        execAndSlot.executionAttempt.deployToSlot(slot);
                                    }
                                }
                                break block10;
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            try {
                                ExecutionGraph.this.failGlobal(t);
                            }
                            finally {
                                ExecutionGraphUtils.releaseAllSlotsSilently(resources);
                            }
                        }
                    }
                    return null;
                }
            }, this.futureExecutor);
            successful = true;
        }
        finally {
            if (!successful) {
                ExecutionGraphUtils.releaseAllSlotsSilently(resources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        while (true) {
            JobStatus current;
            if ((current = this.state) == JobStatus.RUNNING || current == JobStatus.CREATED) {
                if (!this.transitionState(current, JobStatus.CANCELLING)) continue;
                this.incrementGlobalModVersion();
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(this.verticesInCreationOrder.size());
                for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
                    futures.add(ejv.cancelWithFuture());
                }
                FutureUtils.ConjunctFuture<Void> allTerminal = FutureUtils.waitForAll(futures);
                allTerminal.thenAccept(new AcceptFunction<Void>(){

                    @Override
                    public void accept(Void value) {
                        ExecutionGraph.this.allVerticesInTerminalState();
                    }
                });
                return;
            }
            if (current == JobStatus.FAILING) {
                if (!this.transitionState(current, JobStatus.CANCELLING)) continue;
                return;
            }
            if (current != JobStatus.RESTARTING) break;
            Object object = this.progressLock;
            synchronized (object) {
                if (this.transitionState(current, JobStatus.CANCELED)) {
                    this.onTerminalState(JobStatus.CANCELED);
                    LOG.info("Canceled during restart.");
                    return;
                }
            }
        }
    }

    public void stop() throws StoppingException {
        if (this.isStoppable) {
            for (ExecutionVertex ev : this.getAllExecutionVertices()) {
                if (ev.getNumberOfInputs() != 0) continue;
                ev.stop();
            }
        } else {
            throw new StoppingException("This job is not stoppable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Throwable suspensionCause) {
        JobStatus currentState;
        do {
            if (!(currentState = this.state).isTerminalState()) continue;
            return;
        } while (!this.transitionState(currentState, JobStatus.SUSPENDED, suspensionCause));
        this.failureCause = suspensionCause;
        this.incrementGlobalModVersion();
        for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
            ejv.cancel();
        }
        Object object = this.progressLock;
        synchronized (object) {
            this.onTerminalState(JobStatus.SUSPENDED);
            LOG.info("Job {} has been suspended.", (Object)this.getJobID());
        }
    }

    public void failGlobal(Throwable t) {
        while (true) {
            JobStatus current;
            if ((current = this.state) == JobStatus.FAILING || current == JobStatus.SUSPENDED || current.isGloballyTerminalState()) {
                return;
            }
            if (current == JobStatus.RESTARTING) {
                this.failureCause = t;
                if (!this.tryRestartOrFail()) continue;
                return;
            }
            if (this.transitionState(current, JobStatus.FAILING, t)) break;
        }
        this.failureCause = t;
        this.incrementGlobalModVersion();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(this.verticesInCreationOrder.size());
        for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
            futures.add(ejv.cancelWithFuture());
        }
        FutureUtils.ConjunctFuture<Void> allTerminal = FutureUtils.waitForAll(futures);
        allTerminal.thenAccept(new AcceptFunction<Void>(){

            @Override
            public void accept(Void value) {
                ExecutionGraph.this.allVerticesInTerminalState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        try {
            Object object = this.progressLock;
            synchronized (object) {
                JobStatus current = this.state;
                if (current == JobStatus.CANCELED) {
                    LOG.info("Canceled job during restart. Aborting restart.");
                    return;
                }
                if (current == JobStatus.FAILED) {
                    LOG.info("Failed job during restart. Aborting restart.");
                    return;
                }
                if (current == JobStatus.SUSPENDED) {
                    LOG.info("Suspended job during restart. Aborting restart.");
                    return;
                }
                if (current != JobStatus.RESTARTING) {
                    throw new IllegalStateException("Can only restart job from state restarting.");
                }
                this.currentExecutions.clear();
                HashSet<CoLocationGroup> colGroups = new HashSet<CoLocationGroup>();
                long resetTimestamp = System.currentTimeMillis();
                for (ExecutionJobVertex jv : this.verticesInCreationOrder) {
                    CoLocationGroup cgroup = jv.getCoLocationGroup();
                    if (cgroup != null && !colGroups.contains(cgroup)) {
                        cgroup.resetConstraints();
                        colGroups.add(cgroup);
                    }
                    jv.resetForNewExecution(resetTimestamp, this.globalModVersion);
                }
                for (int i = 0; i < this.stateTimestamps.length; ++i) {
                    if (i == JobStatus.RESTARTING.ordinal()) continue;
                    this.stateTimestamps[i] = 0L;
                }
                this.transitionState(JobStatus.RESTARTING, JobStatus.CREATED);
                if (this.checkpointCoordinator != null) {
                    this.checkpointCoordinator.restoreLatestCheckpointedState(this.getAllVertices(), false, false);
                }
            }
            this.scheduleForExecution();
        }
        catch (Throwable t) {
            LOG.warn("Failed to restart the job.", t);
            this.failGlobal(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreLatestCheckpointedState(boolean errorIfNoCheckpoint, boolean allowNonRestoredState) throws Exception {
        Object object = this.progressLock;
        synchronized (object) {
            if (this.checkpointCoordinator != null) {
                this.checkpointCoordinator.restoreLatestCheckpointedState(this.getAllVertices(), errorIfNoCheckpoint, allowNonRestoredState);
            }
        }
    }

    @Override
    public ArchivedExecutionConfig getArchivedExecutionConfig() {
        try {
            ExecutionConfig executionConfig = (ExecutionConfig)this.jobInformation.getSerializedExecutionConfig().deserializeValue(this.userClassLoader);
            if (executionConfig != null) {
                return executionConfig.archive();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Couldn't create ArchivedExecutionConfig for job {} ", (Object)this.getJobID(), (Object)e);
        }
        return null;
    }

    @VisibleForTesting
    public Future<JobStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    @VisibleForTesting
    public JobStatus waitUntilTerminal() throws InterruptedException {
        try {
            return (JobStatus)((Object)this.terminationFuture.get());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public FailoverStrategy getFailoverStrategy() {
        return this.failoverStrategy;
    }

    long getGlobalModVersion() {
        return this.globalModVersion;
    }

    private boolean transitionState(JobStatus current, JobStatus newState) {
        return this.transitionState(current, newState, null);
    }

    private boolean transitionState(JobStatus current, JobStatus newState, Throwable error) {
        if (current.isTerminalState()) {
            String message = "Job is trying to leave terminal state " + (Object)((Object)current);
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (STATE_UPDATER.compareAndSet(this, current, newState)) {
            LOG.info("Job {} ({}) switched from state {} to {}.", new Object[]{this.getJobName(), this.getJobID(), current, newState, error});
            this.stateTimestamps[newState.ordinal()] = System.currentTimeMillis();
            this.notifyJobStatusChange(newState, error);
            return true;
        }
        return false;
    }

    private long incrementGlobalModVersion() {
        return GLOBAL_VERSION_UPDATER.incrementAndGet(this);
    }

    void vertexFinished() {
        int numFinished = this.verticesFinished.incrementAndGet();
        if (numFinished == this.numVerticesTotal && this.state == JobStatus.RUNNING) {
            try {
                for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
                    ejv.getJobVertex().finalizeOnMaster(this.getUserClassLoader());
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.failGlobal(new Exception("Failed to finalize execution on master", t));
                return;
            }
            if (this.transitionState(JobStatus.RUNNING, JobStatus.FINISHED)) {
                this.onTerminalState(JobStatus.FINISHED);
            }
        }
    }

    void vertexUnFinished() {
        this.verticesFinished.getAndDecrement();
    }

    private void allVerticesInTerminalState() {
        block5: {
            JobStatus current;
            block6: {
                while (true) {
                    if ((current = this.state) == JobStatus.RUNNING) {
                        this.failGlobal(new Exception("ExecutionGraph went into allVerticesInTerminalState() from RUNNING"));
                        continue;
                    }
                    if (current == JobStatus.CANCELLING) {
                        if (!this.transitionState(current, JobStatus.CANCELED)) continue;
                        this.onTerminalState(JobStatus.CANCELED);
                        break block5;
                    }
                    if (current != JobStatus.FAILING) break block6;
                    if (this.tryRestartOrFail()) break;
                }
                break block5;
            }
            if (current == JobStatus.SUSPENDED) break block5;
            if (current.isGloballyTerminalState()) {
                LOG.warn("Job has entered globally terminal state without waiting for all job vertices to reach final state.");
            } else {
                this.failGlobal(new Exception("ExecutionGraph went into final state from state " + (Object)((Object)current)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryRestartOrFail() {
        JobStatus currentState = this.state;
        if (currentState == JobStatus.FAILING || currentState == JobStatus.RESTARTING) {
            Object object = this.progressLock;
            synchronized (object) {
                boolean isRestartable;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Try to restart or fail the job {} ({}) if no longer possible.", new Object[]{this.getJobName(), this.getJobID(), this.failureCause});
                } else {
                    LOG.info("Try to restart or fail the job {} ({}) if no longer possible.", (Object)this.getJobName(), (Object)this.getJobID());
                }
                boolean isFailureCauseAllowingRestart = !(this.failureCause instanceof SuppressRestartsException);
                boolean isRestartStrategyAllowingRestart = this.restartStrategy.canRestart();
                boolean bl = isRestartable = isFailureCauseAllowingRestart && isRestartStrategyAllowingRestart;
                if (isRestartable && this.transitionState(currentState, JobStatus.RESTARTING)) {
                    LOG.info("Restarting the job {} ({}).", (Object)this.getJobName(), (Object)this.getJobID());
                    this.restartStrategy.restart(this);
                    return true;
                }
                if (!isRestartable && this.transitionState(currentState, JobStatus.FAILED, this.failureCause)) {
                    String cause1 = isFailureCauseAllowingRestart ? null : "a type of SuppressRestartsException was thrown";
                    String cause2 = isRestartStrategyAllowingRestart ? null : "the restart strategy prevented it";
                    LOG.info("Could not restart the job {} ({}) because {}.", new Object[]{this.getJobName(), this.getJobID(), StringUtils.concatenateWithAnd((String)cause1, (String)cause2), this.failureCause});
                    this.onTerminalState(JobStatus.FAILED);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void onTerminalState(JobStatus status) {
        try {
            CheckpointCoordinator coord = this.checkpointCoordinator;
            this.checkpointCoordinator = null;
            if (coord != null) {
                coord.shutdown(status);
            }
        }
        catch (Exception e) {
            LOG.error("Error while cleaning up after execution", (Throwable)e);
        }
        finally {
            this.terminationFuture.complete(status);
        }
    }

    public boolean updateState(TaskExecutionState state) {
        Execution attempt = this.currentExecutions.get((Object)state.getID());
        if (attempt != null) {
            try {
                switch (state.getExecutionState()) {
                    case RUNNING: {
                        return attempt.switchToRunning();
                    }
                    case FINISHED: {
                        Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                        attempt.markFinished(accumulators, state.getIOMetrics());
                        return true;
                    }
                    case CANCELED: {
                        Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                        attempt.cancelingComplete(accumulators, state.getIOMetrics());
                        return true;
                    }
                    case FAILED: {
                        Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                        attempt.markFailed(state.getError(this.userClassLoader), accumulators, state.getIOMetrics());
                        return true;
                    }
                }
                attempt.fail(new Exception("TaskManager sent illegal state update: " + (Object)((Object)state.getExecutionState())));
                return false;
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                this.failGlobal(t);
                return false;
            }
        }
        return false;
    }

    private Map<String, Accumulator<?, ?>> deserializeAccumulators(TaskExecutionState state) {
        AccumulatorSnapshot serializedAccumulators = state.getAccumulators();
        if (serializedAccumulators != null) {
            try {
                return serializedAccumulators.deserializeUserAccumulators(this.userClassLoader);
            }
            catch (Throwable t) {
                LOG.error("Failed to deserialize final accumulator results.", t);
            }
        }
        return null;
    }

    public void scheduleOrUpdateConsumers(ResultPartitionID partitionId) throws ExecutionGraphException {
        Execution execution = this.currentExecutions.get((Object)partitionId.getProducerId());
        if (execution == null) {
            throw new ExecutionGraphException("Cannot find execution for execution Id " + (Object)((Object)partitionId.getPartitionId()) + '.');
        }
        if (execution.getVertex() == null) {
            throw new ExecutionGraphException("Execution with execution Id " + (Object)((Object)partitionId.getPartitionId()) + " has no vertex assigned.");
        }
        execution.getVertex().scheduleOrUpdateConsumers(partitionId);
    }

    public Map<ExecutionAttemptID, Execution> getRegisteredExecutions() {
        return Collections.unmodifiableMap(this.currentExecutions);
    }

    void registerExecution(Execution exec) {
        Execution previous = this.currentExecutions.putIfAbsent(exec.getAttemptId(), exec);
        if (previous != null) {
            this.failGlobal(new Exception("Trying to register execution " + exec + " for already used ID " + (Object)((Object)exec.getAttemptId())));
        }
    }

    void deregisterExecution(Execution exec) {
        Execution contained = this.currentExecutions.remove((Object)exec.getAttemptId());
        if (contained != null && contained != exec) {
            this.failGlobal(new Exception("De-registering execution " + exec + " failed. Found for same ID execution " + contained));
        }
    }

    public void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        try {
            Map<String, Accumulator<?, ?>> userAccumulators = accumulatorSnapshot.deserializeUserAccumulators(this.userClassLoader);
            ExecutionAttemptID execID = accumulatorSnapshot.getExecutionAttemptID();
            Execution execution = this.currentExecutions.get((Object)execID);
            if (execution != null) {
                execution.setAccumulators(userAccumulators);
            } else {
                LOG.debug("Received accumulator result for unknown execution {}.", (Object)execID);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot update accumulators for job {}.", (Object)this.getJobID(), (Object)e);
        }
    }

    public void registerJobStatusListener(JobStatusListener listener) {
        if (listener != null) {
            this.jobStatusListeners.add(listener);
        }
    }

    public void registerExecutionListener(ExecutionStatusListener listener) {
        if (listener != null) {
            this.executionListeners.add(listener);
        }
    }

    private void notifyJobStatusChange(JobStatus newState, Throwable error) {
        if (this.jobStatusListeners.size() > 0) {
            long timestamp = System.currentTimeMillis();
            SerializedThrowable serializedError = error == null ? null : new SerializedThrowable(error);
            for (JobStatusListener listener : this.jobStatusListeners) {
                try {
                    listener.jobStatusChanges(this.getJobID(), newState, timestamp, serializedError);
                }
                catch (Throwable t) {
                    LOG.warn("Error while notifying JobStatusListener", t);
                }
            }
        }
    }

    void notifyExecutionChange(Execution execution, ExecutionState newExecutionState, Throwable error) {
        if (this.executionListeners.size() > 0) {
            ExecutionJobVertex vertex = execution.getVertex().getJobVertex();
            String message = error == null ? null : ExceptionUtils.stringifyException((Throwable)error);
            long timestamp = System.currentTimeMillis();
            for (ExecutionStatusListener listener : this.executionListeners) {
                try {
                    listener.executionStatusChanged(this.getJobID(), vertex.getJobVertexId(), vertex.getJobVertex().getName(), vertex.getParallelism(), execution.getParallelSubtaskIndex(), execution.getAttemptId(), newExecutionState, timestamp, message);
                }
                catch (Throwable t) {
                    LOG.warn("Error while notifying ExecutionStatusListener", t);
                }
            }
        }
        if (newExecutionState == ExecutionState.FAILED) {
            Throwable ex;
            Throwable throwable = ex = error != null ? error : new FlinkException("Unknown Error (missing cause)");
            if (execution.getGlobalModVersion() == this.globalModVersion) {
                try {
                    this.failoverStrategy.onTaskFailure(execution, ex);
                }
                catch (Throwable t) {
                    LOG.warn("Error in failover strategy - falling back to global restart", t);
                    this.failGlobal(ex);
                }
            }
        }
    }

    public ArchivedExecutionGraph archive() {
        Map<String, Object> serializedUserAccumulators;
        HashMap<JobVertexID, ArchivedExecutionJobVertex> archivedTasks = new HashMap<JobVertexID, ArchivedExecutionJobVertex>();
        ArrayList<ArchivedExecutionJobVertex> archivedVerticesInCreationOrder = new ArrayList<ArchivedExecutionJobVertex>();
        for (ExecutionJobVertex task : this.verticesInCreationOrder) {
            ArchivedExecutionJobVertex archivedTask = task.archive();
            archivedVerticesInCreationOrder.add(archivedTask);
            archivedTasks.put(task.getJobVertexId(), archivedTask);
        }
        try {
            serializedUserAccumulators = this.getAccumulatorsSerialized();
        }
        catch (Exception e) {
            LOG.warn("Error occurred while archiving user accumulators.", (Throwable)e);
            serializedUserAccumulators = Collections.emptyMap();
        }
        return new ArchivedExecutionGraph(this.getJobID(), this.getJobName(), archivedTasks, archivedVerticesInCreationOrder, this.stateTimestamps, this.getState(), this.getFailureCauseAsString(), this.getJsonPlan(), this.getAccumulatorResultsStringified(), serializedUserAccumulators, this.getArchivedExecutionConfig(), this.isStoppable(), this.getJobCheckpointingSettings(), this.getCheckpointStatsSnapshot());
    }
}

