/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class SavepointV2
implements Savepoint {
    public static final int VERSION = 2;
    private final long checkpointId;
    @Deprecated
    private final Collection<TaskState> taskStates;
    private final Collection<OperatorState> operatorStates;
    private final Collection<MasterState> masterStates;

    @Deprecated
    public SavepointV2(long checkpointId, Collection<TaskState> taskStates) {
        this(checkpointId, null, (Collection)Preconditions.checkNotNull(taskStates, (String)"taskStates"), Collections.emptyList());
    }

    public SavepointV2(long checkpointId, Collection<OperatorState> operatorStates, Collection<MasterState> masterStates) {
        this(checkpointId, (Collection)Preconditions.checkNotNull(operatorStates, (String)"operatorStates"), null, masterStates);
    }

    private SavepointV2(long checkpointId, Collection<OperatorState> operatorStates, Collection<TaskState> taskStates, Collection<MasterState> masterStates) {
        this.checkpointId = checkpointId;
        this.operatorStates = operatorStates;
        this.taskStates = taskStates;
        this.masterStates = (Collection)Preconditions.checkNotNull(masterStates, (String)"masterStates");
    }

    public int getVersion() {
        return 2;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public Collection<OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    @Override
    public Collection<TaskState> getTaskStates() {
        return this.taskStates;
    }

    @Override
    public Collection<MasterState> getMasterStates() {
        return this.masterStates;
    }

    @Override
    public void dispose() throws Exception {
        for (OperatorState operatorState : this.operatorStates) {
            operatorState.discardState();
        }
        this.operatorStates.clear();
        this.masterStates.clear();
    }

    public String toString() {
        return "Checkpoint Metadata (version=2)";
    }

    @Deprecated
    public static Savepoint convertToOperatorStateSavepointV2(Map<JobVertexID, ExecutionJobVertex> tasks, Savepoint savepoint) {
        if (savepoint.getOperatorStates() != null) {
            return savepoint;
        }
        boolean expandedToLegacyIds = false;
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>(savepoint.getTaskStates().size() << 1);
        for (TaskState taskState : savepoint.getTaskStates()) {
            ExecutionJobVertex jobVertex = tasks.get((Object)taskState.getJobVertexID());
            if (jobVertex == null && !expandedToLegacyIds) {
                tasks = ExecutionJobVertex.includeLegacyJobVertexIDs(tasks);
                jobVertex = tasks.get((Object)taskState.getJobVertexID());
                expandedToLegacyIds = true;
            }
            List<OperatorID> operatorIDs = jobVertex.getOperatorIDs();
            for (int subtaskIndex = 0; subtaskIndex < jobVertex.getParallelism(); ++subtaskIndex) {
                SubtaskState subtaskState = taskState.getState(subtaskIndex);
                if (subtaskState == null) continue;
                ChainedStateHandle<StreamStateHandle> nonPartitionedState = subtaskState.getLegacyOperatorState();
                ChainedStateHandle<OperatorStateHandle> partitioneableState = subtaskState.getManagedOperatorState();
                ChainedStateHandle<OperatorStateHandle> rawOperatorState = subtaskState.getRawOperatorState();
                for (int chainIndex = 0; chainIndex < taskState.getChainLength(); ++chainIndex) {
                    for (int o = 0; o < operatorIDs.size(); ++o) {
                        OperatorID operatorID = operatorIDs.get(o);
                        OperatorState operatorState = (OperatorState)operatorStates.get((Object)operatorID);
                        if (operatorState == null) {
                            operatorState = new OperatorState(operatorID, jobVertex.getParallelism(), jobVertex.getMaxParallelism());
                            operatorStates.put(operatorID, operatorState);
                        }
                        KeyedStateHandle managedKeyedState = null;
                        KeyedStateHandle rawKeyedState = null;
                        if (o == operatorIDs.size() - 1) {
                            managedKeyedState = subtaskState.getManagedKeyedState();
                            rawKeyedState = subtaskState.getRawKeyedState();
                        }
                        OperatorSubtaskState operatorSubtaskState = new OperatorSubtaskState(nonPartitionedState != null ? nonPartitionedState.get(o) : null, partitioneableState != null ? partitioneableState.get(o) : null, rawOperatorState != null ? rawOperatorState.get(o) : null, managedKeyedState, rawKeyedState);
                        operatorState.putState(subtaskIndex, operatorSubtaskState);
                    }
                }
            }
        }
        return new SavepointV2(savepoint.getCheckpointId(), operatorStates.values(), savepoint.getMasterStates());
    }
}

