/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedCheckpoint
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpoint.class);
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final long duration;
    private final Map<OperatorID, OperatorState> operatorStates;
    private final CheckpointProperties props;
    private final Collection<MasterState> masterHookStates;
    @Nullable
    private final StreamStateHandle externalizedMetadata;
    @Nullable
    private final String externalPointer;
    @Nullable
    private volatile transient CompletedCheckpointStats.DiscardCallback discardCallback;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<OperatorID, OperatorState> operatorStates, @Nullable Collection<MasterState> masterHookStates, CheckpointProperties props, @Nullable StreamStateHandle externalizedMetadata, @Nullable String externalPointer) {
        Preconditions.checkArgument((checkpointID >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((completionTimestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((externalPointer == null == (externalizedMetadata == null) ? 1 : 0) != 0, (Object)"external pointer without externalized metadata must be both null or both non-null");
        Preconditions.checkArgument((!props.externalizeCheckpoint() || externalPointer != null ? 1 : 0) != 0, (Object)"Checkpoint properties require externalized checkpoint, but checkpoint is not externalized");
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.duration = completionTimestamp - timestamp;
        this.operatorStates = new HashMap<OperatorID, OperatorState>((Map)Preconditions.checkNotNull(operatorStates));
        this.masterHookStates = masterHookStates == null || masterHookStates.isEmpty() ? Collections.emptyList() : new ArrayList<MasterState>(masterHookStates);
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
        this.externalizedMetadata = externalizedMetadata;
        this.externalPointer = externalPointer;
    }

    public JobID getJobId() {
        return this.job;
    }

    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public void discardOnFailedStoring() throws Exception {
        this.doDiscard();
    }

    public boolean discardOnSubsume() throws Exception {
        if (this.props.discardOnSubsumed()) {
            this.doDiscard();
            return true;
        }
        return false;
    }

    public boolean discardOnShutdown(JobStatus jobStatus) throws Exception {
        if (jobStatus == JobStatus.FINISHED && this.props.discardOnJobFinished() || jobStatus == JobStatus.CANCELED && this.props.discardOnJobCancelled() || jobStatus == JobStatus.FAILED && this.props.discardOnJobFailed() || jobStatus == JobStatus.SUSPENDED && this.props.discardOnJobSuspended()) {
            this.doDiscard();
            return true;
        }
        if (this.externalPointer != null) {
            LOG.info("Persistent checkpoint with ID {} at '{}' not discarded.", (Object)this.checkpointID, (Object)this.externalPointer);
        }
        return false;
    }

    private void doDiscard() throws Exception {
        try {
            Exception exception = null;
            if (this.externalizedMetadata != null) {
                try {
                    this.externalizedMetadata.discardState();
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.operatorStates.values());
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.operatorStates.clear();
            CompletedCheckpointStats.DiscardCallback discardCallback = this.discardCallback;
            if (discardCallback != null) {
                discardCallback.notifyDiscardedCheckpoint();
            }
        }
    }

    public long getStateSize() {
        long result = 0L;
        for (OperatorState operatorState : this.operatorStates.values()) {
            result += operatorState.getStateSize();
        }
        return result;
    }

    public Map<OperatorID, OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public Collection<MasterState> getMasterHookStates() {
        return Collections.unmodifiableCollection(this.masterHookStates);
    }

    public boolean isExternalized() {
        return this.externalizedMetadata != null;
    }

    @Nullable
    public StreamStateHandle getExternalizedMetadata() {
        return this.externalizedMetadata;
    }

    @Nullable
    public String getExternalPointer() {
        return this.externalPointer;
    }

    void setDiscardCallback(@Nullable CompletedCheckpointStats.DiscardCallback discardCallback) {
        this.discardCallback = discardCallback;
    }

    public void registerSharedStatesAfterRestored(SharedStateRegistry sharedStateRegistry) {
        sharedStateRegistry.registerAll(this.operatorStates.values());
    }

    public String toString() {
        return String.format("Checkpoint %d @ %d for %s", this.checkpointID, this.timestamp, this.job);
    }
}

