/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.WriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PhysicalWriterImpl
implements PhysicalWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalWriterImpl.class);
    private static final byte[] ZEROS = new byte[65536];
    private static final int HDFS_BUFFER_SIZE = 262144;
    protected final OutStream writer;
    private final CodedOutputStream protobufWriter;
    private final CompressionKind compress;
    private final Map<StreamName, BufferedStream> streams;
    private final HadoopShims shims;
    private final int maxPadding;
    private final int bufferSize;
    private final long blockSize;
    private final boolean addBlockPadding;
    private final boolean writeVariableLengthBlocks;
    private CompressionCodec codec;
    private FSDataOutputStream out;
    private long headerLength;
    private long stripeStart;
    private long blockOffset;
    private int metadataLength;
    private int footerLength;

    public PhysicalWriterImpl(FSDataOutputStream out, OrcFile.WriterOptions opts) throws IOException {
        this.bufferSize = opts.isEnforceBufferSize() ? opts.getBufferSize() : WriterImpl.getEstimatedBufferSize((long)opts.getStripeSize(), (int)(opts.getSchema().getMaximumId() + 1), (int)opts.getBufferSize());
        this.out = out;
        this.blockOffset = 0L;
        this.blockSize = opts.getBlockSize();
        this.maxPadding = (int)(opts.getPaddingTolerance() * (double)opts.getBufferSize());
        this.compress = opts.getCompress();
        this.codec = OrcCodecPool.getCodec((CompressionKind)this.compress);
        this.streams = new TreeMap<StreamName, BufferedStream>();
        this.writer = new OutStream("metadata", this.bufferSize, this.codec, (PhysicalWriter.OutputReceiver)new DirectStream(this.out));
        this.shims = opts.getHadoopShims();
        this.addBlockPadding = opts.getBlockPadding();
        this.protobufWriter = CodedOutputStream.newInstance((OutputStream)this.writer);
        this.writeVariableLengthBlocks = opts.getWriteVariableLengthBlocks();
    }

    public void writeHeader() throws IOException {
        this.out.write("ORC".getBytes());
        this.headerLength = this.out.getPos();
    }

    public PhysicalWriter.OutputReceiver createDataStream(StreamName name) throws IOException {
        BufferedStream result = this.streams.get(name);
        if (result == null) {
            result = new BufferedStream();
            this.streams.put(name, result);
        }
        return result;
    }

    public void writeIndex(StreamName name, OrcProto.RowIndex.Builder index, CompressionCodec codec) throws IOException {
        OutStream stream = new OutStream(this.toString(), this.bufferSize, codec, this.createDataStream(name));
        index.build().writeTo((OutputStream)stream);
        stream.flush();
    }

    public void writeBloomFilter(StreamName name, OrcProto.BloomFilterIndex.Builder bloom, CompressionCodec codec) throws IOException {
        OutStream stream = new OutStream(this.toString(), this.bufferSize, codec, this.createDataStream(name));
        bloom.build().writeTo((OutputStream)stream);
        stream.flush();
    }

    public void finalizeStripe(OrcProto.StripeFooter.Builder footerBuilder, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        long indexSize = 0L;
        long dataSize = 0L;
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            BufferedStream receiver = pair.getValue();
            if (receiver.isSuppressed) continue;
            long streamSize = receiver.getOutputSize();
            StreamName name = pair.getKey();
            footerBuilder.addStreams(OrcProto.Stream.newBuilder().setColumn(name.getColumn()).setKind(name.getKind()).setLength(streamSize));
            if (StreamName.Area.INDEX == name.getArea()) {
                indexSize += streamSize;
                continue;
            }
            dataSize += streamSize;
        }
        dirEntry.setIndexLength(indexSize).setDataLength(dataSize);
        OrcProto.StripeFooter footer = footerBuilder.build();
        this.padStripe(indexSize + dataSize + (long)footer.getSerializedSize());
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            pair.getValue().spillToDiskAndClear(this.out);
        }
        this.writeStripeFooter(footer, dataSize, indexSize, dirEntry);
    }

    public void writeFileMetadata(OrcProto.Metadata.Builder builder) throws IOException {
        long startPosition = this.out.getPos();
        OrcProto.Metadata metadata = builder.build();
        this.writeMetadata(metadata);
        this.metadataLength = (int)(this.out.getPos() - startPosition);
    }

    public void writeFileFooter(OrcProto.Footer.Builder builder) throws IOException {
        long bodyLength = this.out.getPos() - (long)this.metadataLength;
        builder.setContentLength(bodyLength);
        builder.setHeaderLength(this.headerLength);
        long startPosition = this.out.getPos();
        OrcProto.Footer footer = builder.build();
        this.writeFileFooter(footer);
        this.footerLength = (int)(this.out.getPos() - startPosition);
    }

    public long writePostScript(OrcProto.PostScript.Builder builder) throws IOException {
        builder.setFooterLength((long)this.footerLength);
        builder.setMetadataLength((long)this.metadataLength);
        OrcProto.PostScript ps = builder.build();
        long startPosition = this.out.getPos();
        ps.writeTo((OutputStream)this.out);
        long length = this.out.getPos() - startPosition;
        if (length > 255L) {
            throw new IllegalArgumentException("PostScript too large at " + length);
        }
        this.out.write((int)length);
        return this.out.getPos();
    }

    public void close() {
        OrcCodecPool.returnCodec((CompressionKind)this.compress, (CompressionCodec)this.codec);
        this.codec = null;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void appendRawStripe(ByteBuffer buffer, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        long start = this.out.getPos();
        int length = buffer.remaining();
        long availBlockSpace = this.blockSize - start % this.blockSize;
        if ((long)length < this.blockSize && (long)length > availBlockSpace && this.addBlockPadding) {
            byte[] pad = new byte[(int)Math.min(262144L, availBlockSpace)];
            LOG.info(String.format("Padding ORC by %d bytes while merging..", availBlockSpace));
            start += availBlockSpace;
            while (availBlockSpace > 0L) {
                int writeLen = (int)Math.min(availBlockSpace, (long)pad.length);
                this.out.write(pad, 0, writeLen);
                availBlockSpace -= (long)writeLen;
            }
        }
        this.out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), length);
        dirEntry.setOffset(start);
    }

    public CompressionCodec getCompressionCodec() {
        return this.codec;
    }

    public long getFileBytes(int column) {
        long size = 0L;
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            StreamName name;
            BufferedStream receiver = pair.getValue();
            if (receiver.isSuppressed || (name = pair.getKey()).getColumn() != column || name.getArea() == StreamName.Area.INDEX) continue;
            size += receiver.getOutputSize();
        }
        return size;
    }

    private void padStripe(long stripeSize) throws IOException {
        this.stripeStart = this.out.getPos();
        long previousBytesInBlock = (this.stripeStart - this.blockOffset) % this.blockSize;
        if (previousBytesInBlock > 0L && previousBytesInBlock + stripeSize >= this.blockSize) {
            long padding;
            if (this.writeVariableLengthBlocks && this.shims.endVariableLengthBlock((OutputStream)this.out)) {
                this.blockOffset = this.stripeStart;
            } else if (this.addBlockPadding && (padding = this.blockSize - previousBytesInBlock) <= (long)this.maxPadding) {
                PhysicalWriterImpl.writeZeros((OutputStream)this.out, padding);
                this.stripeStart += padding;
            }
        }
    }

    private void writeStripeFooter(OrcProto.StripeFooter footer, long dataSize, long indexSize, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        this.writeStripeFooter(footer);
        dirEntry.setOffset(this.stripeStart);
        dirEntry.setFooterLength(this.out.getPos() - this.stripeStart - dataSize - indexSize);
    }

    protected void writeMetadata(OrcProto.Metadata metadata) throws IOException {
        metadata.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
    }

    protected void writeFileFooter(OrcProto.Footer footer) throws IOException {
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
    }

    protected void writeStripeFooter(OrcProto.StripeFooter footer) throws IOException {
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
    }

    private static void writeZeros(OutputStream output, long remaining) throws IOException {
        while (remaining > 0L) {
            long size = Math.min((long)ZEROS.length, remaining);
            output.write(ZEROS, 0, (int)size);
            remaining -= size;
        }
    }

    private static final class BufferedStream
    implements PhysicalWriter.OutputReceiver {
        private boolean isSuppressed = false;
        private final List<ByteBuffer> output = new ArrayList<ByteBuffer>();

        private BufferedStream() {
        }

        public void output(ByteBuffer buffer) {
            if (!this.isSuppressed) {
                this.output.add(buffer);
            }
        }

        public void suppress() {
            this.isSuppressed = true;
            this.output.clear();
        }

        void spillToDiskAndClear(FSDataOutputStream raw) throws IOException {
            if (!this.isSuppressed) {
                for (ByteBuffer buffer : this.output) {
                    raw.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                }
                this.output.clear();
            }
            this.isSuppressed = false;
        }

        public long getOutputSize() {
            long result = 0L;
            for (ByteBuffer buffer : this.output) {
                result += (long)buffer.remaining();
            }
            return result;
        }
    }

    private static class DirectStream
    implements PhysicalWriter.OutputReceiver {
        private final FSDataOutputStream output;

        DirectStream(FSDataOutputStream output) {
            this.output = output;
        }

        public void output(ByteBuffer buffer) throws IOException {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }

        public void suppress() {
            throw new UnsupportedOperationException("Can't suppress direct stream");
        }
    }
}

