/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import java.util.Collection;
import org.apache.flink.api.common.Plan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class OptimizedPlan
implements Visitable<PlanNode> {
    private final Collection<SourcePlanNode> dataSources;
    private final Collection<SinkPlanNode> dataSinks;
    private final Collection<PlanNode> allNodes;
    private final Plan originalProgram;
    private final String jobName;

    public OptimizedPlan(Collection<SourcePlanNode> sources, Collection<SinkPlanNode> sinks, Collection<PlanNode> allNodes, String jobName, Plan programPlan) {
        this.dataSources = sources;
        this.dataSinks = sinks;
        this.allNodes = allNodes;
        this.jobName = jobName;
        this.originalProgram = programPlan;
    }

    public Collection<SourcePlanNode> getDataSources() {
        return this.dataSources;
    }

    public Collection<SinkPlanNode> getDataSinks() {
        return this.dataSinks;
    }

    public Collection<PlanNode> getAllNodes() {
        return this.allNodes;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Plan getOriginalPlan() {
        return this.originalProgram;
    }

    public void accept(Visitor<PlanNode> visitor) {
        for (SinkPlanNode node : this.dataSinks) {
            node.accept(visitor);
        }
    }
}

