/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.taskmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptionsInternal;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesTaskExecutorRunner {
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesTaskExecutorRunner.class);

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"Kubernetes TaskExecutor runner", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        KubernetesTaskExecutorRunner.runTaskManagerSecurely(args);
    }

    private static void runTaskManagerSecurely(String[] args) {
        Configuration configuration = null;
        try {
            configuration = TaskManagerRunner.loadConfiguration((String[])args);
            String nodeId = System.getenv().get("_POD_NODE_ID");
            Preconditions.checkState((nodeId != null ? 1 : 0) != 0, (String)"The environment variable %s is not set, which is used to identify the node where the task manager is located.", (Object[])new Object[]{"_POD_NODE_ID"});
            configuration.setString(TaskManagerOptionsInternal.TASK_MANAGER_NODE_ID, nodeId);
        }
        catch (FlinkParseException fpe) {
            LOG.error("Could not load the configuration.", (Throwable)fpe);
            System.exit(1);
        }
        TaskManagerRunner.runTaskManagerProcessSecurely((Configuration)((Configuration)Preconditions.checkNotNull((Object)configuration)));
    }
}

