/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.ReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LockException;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLock
implements Lock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapLock.class);
    private final String configMapNamespace;
    private final String configMapName;
    private final String identity;
    private final ObjectMapper objectMapper;

    public ConfigMapLock(String configMapNamespace, String configMapName, String identity) {
        this.configMapNamespace = Objects.requireNonNull(configMapNamespace, "configMapNamespace is required");
        this.configMapName = Objects.requireNonNull(configMapName, "configMapName is required");
        this.identity = Objects.requireNonNull(identity, "identity is required");
        this.objectMapper = Serialization.jsonMapper();
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> LeaderElectionRecord get(C client) {
        ConfigMap configMap = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
        return Optional.ofNullable(configMap).map(ConfigMap::getMetadata).map(ObjectMeta::getAnnotations).map(annotations -> (String)annotations.get("control-plane.alpha.kubernetes.io/leader")).map(annotation -> {
            try {
                return this.objectMapper.readValue((String)annotation, new TypeReference<LeaderElectionRecord>(){});
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Error deserializing LeaderElectionRecord from ConfigMap", (Throwable)ex);
                return null;
            }
        }).map(record -> {
            record.setVersion((Serializable)((Object)configMap.getMetadata().getResourceVersion()));
            return record;
        }).orElse(null);
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void create(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).create(((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().editOrNewMetadata().withNamespace(this.configMapNamespace)).withName(this.configMapName)).addToAnnotations("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString(leaderElectionRecord))).endMetadata()).build());
        }
        catch (Exception e) {
            throw new LockException("Unable to create ConfigMapLock", e);
        }
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void update(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ConfigMap toReplace = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
            toReplace.getMetadata().getAnnotations().put("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString(leaderElectionRecord));
            ((ReplaceDeletable)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).lockResourceVersion((String)((Object)Objects.requireNonNull(leaderElectionRecord.getVersion())))).replace(toReplace);
        }
        catch (Exception e) {
            throw new LockException("Unable to update ConfigMapLock", e);
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return String.format("ConfigMapLock: %s - %s (%s)", this.configMapNamespace, this.configMapName, this.identity);
    }
}

