/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.maxwell;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.formats.json.maxwell.MaxwellJsonDeserializationSchema;
import org.apache.flink.formats.json.maxwell.MaxwellJsonOptions;
import org.apache.flink.formats.json.maxwell.MaxwellJsonSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class MaxwellJsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "maxwell-json";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        MaxwellJsonOptions.validateDecodingFormatOptions(formatOptions);
        final boolean ignoreParseErrors = (Boolean)formatOptions.get(MaxwellJsonOptions.IGNORE_PARSE_ERRORS);
        final TimestampFormat timestampFormatOption = JsonOptions.getTimestampFormat(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType rowType = (RowType)producedDataType.getLogicalType();
                TypeInformation rowDataTypeInfo = context.createTypeInformation(producedDataType);
                return new MaxwellJsonDeserializationSchema(rowType, (TypeInformation<RowData>)rowDataTypeInfo, ignoreParseErrors, timestampFormatOption);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        MaxwellJsonOptions.validateEncodingFormatOptions(formatOptions);
        final TimestampFormat timestampFormat = JsonOptions.getTimestampFormat(formatOptions);
        final JsonOptions.MapNullKeyMode mapNullKeyMode = JsonOptions.getMapNullKeyMode(formatOptions);
        final String mapNullKeyLiteral = (String)formatOptions.get(MaxwellJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new MaxwellJsonSerializationSchema(rowType, timestampFormat, mapNullKeyMode, mapNullKeyLiteral);
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MaxwellJsonOptions.IGNORE_PARSE_ERRORS);
        options.add(MaxwellJsonOptions.TIMESTAMP_FORMAT);
        options.add(MaxwellJsonOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(MaxwellJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        return options;
    }
}

