/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class JsonRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowDataToJsonConverters.RowDataToJsonConverter runtimeConverter;
    private final ObjectMapper mapper = new ObjectMapper();
    private transient ObjectNode node;
    private final TimestampFormat timestampFormat;
    private final JsonOptions.MapNullKeyMode mapNullKeyMode;
    private final String mapNullKeyLiteral;

    public JsonRowDataSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral) {
        this.rowType = rowType;
        this.timestampFormat = timestampFormat;
        this.mapNullKeyMode = mapNullKeyMode;
        this.mapNullKeyLiteral = mapNullKeyLiteral;
        this.runtimeConverter = new RowDataToJsonConverters(timestampFormat, mapNullKeyMode, mapNullKeyLiteral).createConverter((LogicalType)rowType);
    }

    public byte[] serialize(RowData row) {
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.mapper, (JsonNode)this.node, row);
            return this.mapper.writeValueAsBytes((Object)this.node);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'. ", t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDataSerializationSchema that = (JsonRowDataSerializationSchema)o;
        return this.rowType.equals((Object)that.rowType) && this.timestampFormat.equals((Object)that.timestampFormat) && this.mapNullKeyMode.equals((Object)that.mapNullKeyMode) && this.mapNullKeyLiteral.equals(that.mapNullKeyLiteral);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowType, this.timestampFormat, this.mapNullKeyMode, this.mapNullKeyLiteral});
    }
}

