/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractParameterToolTest {
    @TempDir
    Path tempPath;

    @Test
    void testThrowExceptionIfParameterIsNotPrefixed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createParameterToolFromArgs(new String[]{"a"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Error parsing arguments '[a]' on 'a'. Please prefix keys with -- or -.");
    }

    @Test
    void testNoVal() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-berlin"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isOne();
        Assertions.assertThat((boolean)parameter.has("berlin")).isTrue();
    }

    @Test
    void testNoValDouble() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--berlin"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isOne();
        Assertions.assertThat((boolean)parameter.has("berlin")).isTrue();
    }

    @Test
    void testMultipleNoVal() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--a", "--b", "--c", "--d", "--e", "--f"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(6);
        Assertions.assertThat((boolean)parameter.has("a")).isTrue();
        Assertions.assertThat((boolean)parameter.has("b")).isTrue();
        Assertions.assertThat((boolean)parameter.has("c")).isTrue();
        Assertions.assertThat((boolean)parameter.has("d")).isTrue();
        Assertions.assertThat((boolean)parameter.has("e")).isTrue();
        Assertions.assertThat((boolean)parameter.has("f")).isTrue();
    }

    @Test
    void testMultipleNoValMixed() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--a", "-b", "-c", "-d", "--e", "--f"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(6);
        Assertions.assertThat((boolean)parameter.has("a")).isTrue();
        Assertions.assertThat((boolean)parameter.has("b")).isTrue();
        Assertions.assertThat((boolean)parameter.has("c")).isTrue();
        Assertions.assertThat((boolean)parameter.has("d")).isTrue();
        Assertions.assertThat((boolean)parameter.has("e")).isTrue();
        Assertions.assertThat((boolean)parameter.has("f")).isTrue();
    }

    @Test
    void testEmptyVal() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createParameterToolFromArgs(new String[]{"--a", "-b", "--"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("The input [--a, -b, --] contains an empty argument");
    }

    @Test
    void testEmptyValShort() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createParameterToolFromArgs(new String[]{"--a", "-b", "-"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("The input [--a, -b, -] contains an empty argument");
    }

    @Test
    void testUnrequestedBoolean() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"boolean"});
        Assertions.assertThat((boolean)parameter.getBoolean("boolean")).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((boolean)parameter.getBoolean("boolean")).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedBooleanWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"boolean"});
        Assertions.assertThat((boolean)parameter.getBoolean("boolean", false)).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((boolean)parameter.getBoolean("boolean", false)).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedBooleanWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"boolean"});
        parameter.getBoolean("boolean");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedByte() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte", "1"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"byte"});
        Assertions.assertThat((byte)parameter.getByte("byte")).isOne();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((byte)parameter.getByte("byte")).isOne();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedByteWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte", "1"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"byte"});
        Assertions.assertThat((byte)parameter.getByte("byte", (byte)0)).isEqualTo((byte)1);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((byte)parameter.getByte("byte", (byte)0)).isEqualTo((byte)1);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedByteWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"byte"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getByte("byte")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedShort() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short", "2"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"short"});
        Assertions.assertThat((short)parameter.getShort("short")).isEqualTo((short)2);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((short)parameter.getShort("short")).isEqualTo((short)2);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedShortWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short", "2"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"short"});
        Assertions.assertThat((short)parameter.getShort("short", (short)0)).isEqualTo((short)2);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((short)parameter.getShort("short", (short)0)).isEqualTo((short)2);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedShortWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"short"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getShort("short")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedInt() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int", "4"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"int"});
        Assertions.assertThat((int)parameter.getInt("int")).isEqualTo(4);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((int)parameter.getInt("int")).isEqualTo(4);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedIntWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int", "4"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"int"});
        Assertions.assertThat((int)parameter.getInt("int", 0)).isEqualTo(4);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((int)parameter.getInt("int", 0)).isEqualTo(4);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedIntWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"int"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getInt("int")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedLong() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long", "8"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"long"});
        Assertions.assertThat((long)parameter.getLong("long")).isEqualTo(8L);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((long)parameter.getLong("long")).isEqualTo(8L);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedLongWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long", "8"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"long"});
        Assertions.assertThat((long)parameter.getLong("long", 0L)).isEqualTo(8L);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((long)parameter.getLong("long", 0L)).isEqualTo(8L);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedLongWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"long"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getLong("long")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedFloat() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float", "4"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"float"});
        Assertions.assertThat((float)parameter.getFloat("float")).isCloseTo(4.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((float)parameter.getFloat("float")).isCloseTo(4.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedFloatWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float", "4"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"float"});
        Assertions.assertThat((float)parameter.getFloat("float", 0.0f)).isCloseTo(4.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((float)parameter.getFloat("float", 0.0f)).isCloseTo(4.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedFloatWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"float"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getFloat("float")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedDouble() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double", "8"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"double"});
        Assertions.assertThat((double)parameter.getDouble("double")).isCloseTo(8.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((double)parameter.getDouble("double")).isCloseTo(8.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedDoubleWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double", "8"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"double"});
        Assertions.assertThat((double)parameter.getDouble("double", 0.0)).isCloseTo(8.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((double)parameter.getDouble("double", 0.0)).isCloseTo(8.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedDoubleWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"double"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.getDouble("double")).isInstanceOf(RuntimeException.class)).hasMessageContaining("For input string: \"__NO_VALUE_KEY\"");
    }

    @Test
    void testUnrequestedString() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string", "\u221e"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"string"});
        Assertions.assertThat((String)parameter.get("string")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((String)parameter.get("string")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedStringWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string", "\u221e"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"string"});
        Assertions.assertThat((String)parameter.get("string", "0.0")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((String)parameter.get("string", "0.0")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedStringWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"string"});
        parameter.get("string");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedHas() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"boolean"});
        Assertions.assertThat((boolean)parameter.has("boolean")).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((boolean)parameter.has("boolean")).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedRequired() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-required", "\u221e"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"required"});
        Assertions.assertThat((String)parameter.getRequired("required")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((String)parameter.getRequired("required")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedMultiple() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true", "-byte", "1", "-short", "2", "-int", "4", "-long", "8", "-float", "4.0", "-double", "8.0", "-string", "\u221e"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"boolean", "byte", "short", "int", "long", "float", "double", "string"});
        Assertions.assertThat((boolean)parameter.getBoolean("boolean")).isTrue();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "string"});
        Assertions.assertThat((byte)parameter.getByte("byte")).isOne();
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"short", "int", "long", "float", "double", "string"});
        Assertions.assertThat((short)parameter.getShort("short")).isEqualTo((short)2);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"int", "long", "float", "double", "string"});
        Assertions.assertThat((int)parameter.getInt("int")).isEqualTo(4);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"long", "float", "double", "string"});
        Assertions.assertThat((long)parameter.getLong("long")).isEqualTo(8L);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"float", "double", "string"});
        Assertions.assertThat((float)parameter.getFloat("float")).isCloseTo(4.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"double", "string"});
        Assertions.assertThat((double)parameter.getDouble("double")).isCloseTo(8.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactly((Object[])new String[]{"string"});
        Assertions.assertThat((String)parameter.get("string")).isEqualTo("\u221e");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testUnrequestedUnknown() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[0]);
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
        Assertions.assertThat((boolean)parameter.getBoolean("boolean", true)).isTrue();
        Assertions.assertThat((byte)parameter.getByte("byte", (byte)0)).isZero();
        Assertions.assertThat((short)parameter.getShort("short", (short)0)).isZero();
        Assertions.assertThat((int)parameter.getInt("int", 0)).isZero();
        Assertions.assertThat((long)parameter.getLong("long", 0L)).isZero();
        Assertions.assertThat((float)parameter.getFloat("float", 0.0f)).isCloseTo(0.0f, Offset.offset((Number)Float.valueOf(1.0E-5f)));
        Assertions.assertThat((double)parameter.getDouble("double", 0.0)).isCloseTo(0.0, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((String)parameter.get("string", "0")).isEqualTo("0");
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    protected AbstractParameterTool createParameterToolFromArgs(String[] args) {
        return ParameterTool.fromArgs((String[])args);
    }

    protected static <T> Set<T> createHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    protected void validate(AbstractParameterTool parameter) {
        ClosureCleaner.ensureSerializable((Object)parameter);
        this.internalValidate(parameter);
        try {
            byte[] b = InstantiationUtil.serializeObject((Object)parameter);
            AbstractParameterTool copy = (AbstractParameterTool)InstantiationUtil.deserializeObject((byte[])b, (ClassLoader)this.getClass().getClassLoader());
            this.internalValidate(copy);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalValidate(AbstractParameterTool parameter) {
        Assertions.assertThat((String)parameter.getRequired("input")).isEqualTo("myInput");
        Assertions.assertThat((String)parameter.get("output", "myDefaultValue")).isEqualTo("myDefaultValue");
        Assertions.assertThat((String)parameter.get("whatever")).isNull();
        Assertions.assertThat((long)parameter.getLong("expectedCount", -1L)).isEqualTo(15L);
        Assertions.assertThat((boolean)parameter.getBoolean("thisIsUseful", true)).isTrue();
        Assertions.assertThat((byte)parameter.getByte("myDefaultByte", (byte)42)).isEqualTo((byte)42);
        Assertions.assertThat((short)parameter.getShort("myDefaultShort", (short)42)).isEqualTo((short)42);
        if (parameter instanceof ParameterTool) {
            ParameterTool parameterTool = (ParameterTool)parameter;
            Configuration config = parameterTool.getConfiguration();
            Assertions.assertThat((long)config.getLong(ConfigOptions.key((String)"expectedCount").longType().defaultValue((Object)-1L))).isEqualTo(15L);
            Properties props = parameterTool.getProperties();
            Assertions.assertThat((String)props.getProperty("input")).isEqualTo("myInput");
            try {
                String pathToFile = this.tempPath.toFile().getAbsolutePath();
                parameterTool.createPropertiesFile(pathToFile);
                Properties defaultProps = new Properties();
                try (FileInputStream fis = new FileInputStream(pathToFile);){
                    defaultProps.load(fis);
                }
                ((MapAssert)((MapAssert)Assertions.assertThat((Map)defaultProps).containsEntry((Object)"output", (Object)"myDefaultValue")).containsEntry((Object)"expectedCount", (Object)"-1")).containsKey((Object)"input");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (parameter instanceof MultipleParameterTool) {
            MultipleParameterTool multipleParameterTool = (MultipleParameterTool)parameter;
            List<String> multiValues = Arrays.asList("multiValue1", "multiValue2");
            Assertions.assertThat((Collection)multipleParameterTool.getMultiParameter("multi")).isEqualTo(multiValues);
            Assertions.assertThat((Map)multipleParameterTool.toMultiMap()).containsEntry((Object)"multi", multiValues);
            Assertions.assertThat((Map)multipleParameterTool.toMap()).containsEntry((Object)"multi", (Object)"multiValue2");
        }
    }
}

