/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.IntegerSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class IntegerSummaryAggregatorTest {
    IntegerSummaryAggregatorTest() {
    }

    @Test
    void testIsNan() {
        IntegerSummaryAggregator ag = new IntegerSummaryAggregator();
        Assertions.assertThat((boolean)ag.isNan(Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Integer.valueOf(23))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Integer.valueOf(Integer.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Integer.valueOf(Integer.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(null)).isFalse();
    }

    @Test
    void testIsInfinite() {
        IntegerSummaryAggregator ag = new IntegerSummaryAggregator();
        Assertions.assertThat((boolean)ag.isInfinite(Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Integer.valueOf(23))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Integer.valueOf(Integer.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Integer.valueOf(Integer.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(null)).isFalse();
    }

    @Test
    void testMean() {
        Assertions.assertThat((Double)this.summarize(0, 100).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0, 0, 100).getMean()).isCloseTo(33.333333, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)this.summarize(0, 0, 100, 100).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0, 100, null).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(new Integer[0]).getMean()).isNull();
    }

    @Test
    void testSum() throws Exception {
        Assertions.assertThat((int)((Integer)this.summarize(0, 100).getSum())).isEqualTo(100);
        Assertions.assertThat((int)((Integer)this.summarize(1, 2, 3, 4, 5).getSum())).isEqualTo(15);
        Assertions.assertThat((int)((Integer)this.summarize(-100, 0, 100, null).getSum())).isZero();
        Assertions.assertThat((int)((Integer)this.summarize(-10, 100, null).getSum())).isEqualTo(90);
        Assertions.assertThat((Integer)((Integer)this.summarize(new Integer[0]).getSum())).isNull();
    }

    @Test
    void testMax() {
        Assertions.assertThat((int)((Integer)this.summarize(-1000, 0, 1, 50, 999, 1001).getMax())).isEqualTo(1001);
        Assertions.assertThat((int)((Integer)this.summarize(Integer.MIN_VALUE, -1000, 0).getMax())).isZero();
        Assertions.assertThat((int)((Integer)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMax())).isEqualTo(11);
        Assertions.assertThat((int)((Integer)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMax())).isEqualTo(11);
        Assertions.assertThat((Integer)((Integer)this.summarize(new Integer[0]).getMax())).isNull();
    }

    @Test
    void testMin() {
        Assertions.assertThat((int)((Integer)this.summarize(-1000, 0, 1, 50, 999, 1001).getMin())).isEqualTo(-1000);
        Assertions.assertThat((int)((Integer)this.summarize(Integer.MIN_VALUE, -1000, 0).getMin())).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)((Integer)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMin())).isEqualTo(-2);
        Assertions.assertThat((int)((Integer)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMin())).isEqualTo(-2);
        Assertions.assertThat((Integer)((Integer)this.summarize(new Integer[0]).getMin())).isNull();
    }

    protected NumericColumnSummary<Integer> summarize(Integer ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Integer, NumericColumnSummary<Integer>, IntegerSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Integer> result1, NumericColumnSummary<Integer> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((int)((Integer)result2.getMin())).isEqualTo(((Integer)result1.getMin()).intValue());
                Assertions.assertThat((int)((Integer)result2.getMax())).isEqualTo(((Integer)result1.getMax()).intValue());
                Assertions.assertThat((int)((Integer)result2.getSum())).isEqualTo(((Integer)result1.getSum()).intValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(values);
    }
}

