/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class FloatSummaryAggregatorTest {
    FloatSummaryAggregatorTest() {
    }

    @Test
    void testAnscomesQuartetXValues() {
        Float[] q1x = new Float[]{Float.valueOf(10.0f), Float.valueOf(8.0f), Float.valueOf(13.0f), Float.valueOf(9.0f), Float.valueOf(11.0f), Float.valueOf(14.0f), Float.valueOf(6.0f), Float.valueOf(4.0f), Float.valueOf(12.0f), Float.valueOf(7.0f), Float.valueOf(5.0f)};
        Float[] q4x = new Float[]{Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(19.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f)};
        NumericColumnSummary<Float> q1 = this.summarize(q1x);
        NumericColumnSummary<Float> q4 = this.summarize(q4x);
        Assertions.assertThat((double)q1.getMean()).isCloseTo(9.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)q4.getMean()).isCloseTo(9.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)q1.getVariance()).isCloseTo(11.0, Offset.offset((Number)1.0E-10));
        Assertions.assertThat((double)q4.getVariance()).isCloseTo(11.0, Offset.offset((Number)1.0E-10));
        double stddev = Math.sqrt(11.0);
        Assertions.assertThat((double)q1.getStandardDeviation()).isCloseTo(stddev, Offset.offset((Number)1.0E-10));
        Assertions.assertThat((double)q4.getStandardDeviation()).isCloseTo(stddev, Offset.offset((Number)1.0E-10));
    }

    @Test
    void testAnscomesQuartetYValues() {
        Float[] q1y = new Float[]{Float.valueOf(8.04f), Float.valueOf(6.95f), Float.valueOf(7.58f), Float.valueOf(8.81f), Float.valueOf(8.33f), Float.valueOf(9.96f), Float.valueOf(7.24f), Float.valueOf(4.26f), Float.valueOf(10.84f), Float.valueOf(4.82f), Float.valueOf(5.68f)};
        Float[] q2y = new Float[]{Float.valueOf(9.14f), Float.valueOf(8.14f), Float.valueOf(8.74f), Float.valueOf(8.77f), Float.valueOf(9.26f), Float.valueOf(8.1f), Float.valueOf(6.13f), Float.valueOf(3.1f), Float.valueOf(9.13f), Float.valueOf(7.26f), Float.valueOf(4.74f)};
        Float[] q3y = new Float[]{Float.valueOf(7.46f), Float.valueOf(6.77f), Float.valueOf(12.74f), Float.valueOf(7.11f), Float.valueOf(7.81f), Float.valueOf(8.84f), Float.valueOf(6.08f), Float.valueOf(5.39f), Float.valueOf(8.15f), Float.valueOf(6.42f), Float.valueOf(5.73f)};
        Float[] q4y = new Float[]{Float.valueOf(6.58f), Float.valueOf(5.76f), Float.valueOf(7.71f), Float.valueOf(8.84f), Float.valueOf(8.47f), Float.valueOf(7.04f), Float.valueOf(5.25f), Float.valueOf(12.5f), Float.valueOf(5.56f), Float.valueOf(7.91f), Float.valueOf(6.89f)};
        NumericColumnSummary<Float> q1 = this.summarize(q1y);
        NumericColumnSummary<Float> q2 = this.summarize(q2y);
        NumericColumnSummary<Float> q3 = this.summarize(q3y);
        NumericColumnSummary<Float> q4 = this.summarize(q4y);
        Assertions.assertThat((double)q1.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q2.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q3.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q4.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q1.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q2.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q3.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q4.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
    }

    @Test
    void testIsNan() {
        FloatSummaryAggregator ag = new FloatSummaryAggregator();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(-1.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(0.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(23.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(Float.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(Float.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Float.valueOf(Float.NaN))).isTrue();
    }

    @Test
    void testIsInfinite() {
        FloatSummaryAggregator ag = new FloatSummaryAggregator();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(-1.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(0.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(23.0f))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(Float.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(Float.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(Float.POSITIVE_INFINITY))).isTrue();
        Assertions.assertThat((boolean)ag.isInfinite(Float.valueOf(Float.NEGATIVE_INFINITY))).isTrue();
    }

    @Test
    void testMean() {
        Assertions.assertThat((Double)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f)).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(100.0f)).getMean()).isCloseTo(33.333333, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)this.summarize(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), Float.valueOf(100.0f)).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f), null).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(new Float[0]).getMean()).isNull();
    }

    @Test
    void testSum() throws Exception {
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f)).getSum()).floatValue()).isCloseTo(100.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)).getSum()).floatValue()).isCloseTo(15.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(-100.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), null).getSum()).floatValue()).isCloseTo(0.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(-10.0f), Float.valueOf(100.0f), null).getSum()).floatValue()).isCloseTo(90.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((Float)((Float)this.summarize(new Float[0]).getSum())).isNull();
    }

    @Test
    void testMax() {
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(-1000.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(50.0f), Float.valueOf(999.0f), Float.valueOf(1001.0f)).getMax()).floatValue()).isCloseTo(1001.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMax()).floatValue()).isCloseTo(11.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), null, Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), null, Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMax()).floatValue()).isCloseTo(11.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(-8.0f), Float.valueOf(-7.0f), Float.valueOf(-6.0f), Float.valueOf(-9.0f), null, Float.valueOf(-10.0f), null, Float.valueOf(-2.0f)).getMax()).floatValue()).isCloseTo(-2.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((Float)((Float)this.summarize(new Float[0]).getMax())).isNull();
    }

    @Test
    void testMin() {
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(-1000.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(50.0f), Float.valueOf(999.0f), Float.valueOf(1001.0f)).getMin()).floatValue()).isCloseTo(-1000.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMin()).floatValue()).isCloseTo(-2.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), null, Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), null, Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMin()).floatValue()).isCloseTo(-2.0f, Offset.offset((Number)Float.valueOf(0.0f)));
        Assertions.assertThat((Float)((Float)this.summarize(new Float[0]).getMin())).isNull();
    }

    protected NumericColumnSummary<Float> summarize(Float ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Float, NumericColumnSummary<Float>, FloatSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Float> result1, NumericColumnSummary<Float> result2) {
                Assertions.assertThat((Float)((Float)result2.getMin())).isCloseTo((Float)result1.getMin(), Offset.offset((Number)Float.valueOf(0.0f)));
                Assertions.assertThat((Float)((Float)result2.getMax())).isCloseTo((Float)result1.getMax(), Offset.offset((Number)Float.valueOf(0.0f)));
                Assertions.assertThat((Double)result2.getMean()).isCloseTo(result1.getMean(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((Double)result2.getVariance()).isCloseTo(result1.getVariance(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((Double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(values);
    }
}

