/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class DoubleSummaryAggregatorTest {
    DoubleSummaryAggregatorTest() {
    }

    @Test
    void testAnscomesQuartetXValues() {
        Double[] q1x = new Double[]{10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0};
        Double[] q4x = new Double[]{8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 19.0, 8.0, 8.0, 8.0};
        NumericColumnSummary<Double> q1 = this.summarize(q1x);
        NumericColumnSummary<Double> q4 = this.summarize(q4x);
        Assertions.assertThat((double)q1.getMean()).isCloseTo(9.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)q4.getMean()).isCloseTo(9.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)q1.getVariance()).isCloseTo(11.0, Offset.offset((Number)1.0E-10));
        Assertions.assertThat((double)q4.getVariance()).isCloseTo(11.0, Offset.offset((Number)1.0E-10));
        double stddev = Math.sqrt(11.0);
        Assertions.assertThat((double)q1.getStandardDeviation()).isCloseTo(stddev, Offset.offset((Number)1.0E-10));
        Assertions.assertThat((double)q4.getStandardDeviation()).isCloseTo(stddev, Offset.offset((Number)1.0E-10));
    }

    @Test
    void testAnscomesQuartetYValues() {
        Double[] q1y = new Double[]{8.04, 6.95, 7.58, 8.81, 8.33, 9.96, 7.24, 4.26, 10.84, 4.82, 5.68};
        Double[] q2y = new Double[]{9.14, 8.14, 8.74, 8.77, 9.26, 8.1, 6.13, 3.1, 9.13, 7.26, 4.74};
        Double[] q3y = new Double[]{7.46, 6.77, 12.74, 7.11, 7.81, 8.84, 6.08, 5.39, 8.15, 6.42, 5.73};
        Double[] q4y = new Double[]{6.58, 5.76, 7.71, 8.84, 8.47, 7.04, 5.25, 12.5, 5.56, 7.91, 6.89};
        NumericColumnSummary<Double> q1 = this.summarize(q1y);
        NumericColumnSummary<Double> q2 = this.summarize(q2y);
        NumericColumnSummary<Double> q3 = this.summarize(q3y);
        NumericColumnSummary<Double> q4 = this.summarize(q4y);
        Assertions.assertThat((double)q1.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q2.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q3.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q4.getMean()).isCloseTo(7.5, Offset.offset((Number)0.001));
        Assertions.assertThat((double)q1.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q2.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q3.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
        Assertions.assertThat((double)q4.getVariance()).isCloseTo(4.12, Offset.offset((Number)0.01));
    }

    @Test
    void testIsNan() {
        DoubleSummaryAggregator ag = new DoubleSummaryAggregator();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(-1.0))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(0.0))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(23.0))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(Double.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(Double.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Double.valueOf(Double.NaN))).isTrue();
    }

    @Test
    void testIsInfinite() {
        DoubleSummaryAggregator ag = new DoubleSummaryAggregator();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(-1.0))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(0.0))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(23.0))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(Double.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(Double.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(Double.POSITIVE_INFINITY))).isTrue();
        Assertions.assertThat((boolean)ag.isInfinite(Double.valueOf(Double.NEGATIVE_INFINITY))).isTrue();
    }

    @Test
    void testMean() {
        Assertions.assertThat((Double)this.summarize(0.0, 100.0).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0.0, 0.0, 100.0).getMean()).isCloseTo(33.333333, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)this.summarize(0.0, 0.0, 100.0, 100.0).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0.0, 100.0, null).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(new Double[0]).getMean()).isNull();
    }

    @Test
    void testSum() throws Exception {
        Assertions.assertThat((double)((Double)this.summarize(0.0, 100.0).getSum())).isCloseTo(100.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(1.0, 2.0, 3.0, 4.0, 5.0).getSum())).isCloseTo(15.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(-100.0, 0.0, 100.0, null).getSum())).isCloseTo(0.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(-10.0, 100.0, null).getSum())).isCloseTo(90.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)((Double)this.summarize(new Double[0]).getSum())).isNull();
    }

    @Test
    void testMax() {
        Assertions.assertThat((double)((Double)this.summarize(-1000.0, 0.0, 1.0, 50.0, 999.0, 1001.0).getMax())).isCloseTo(1001.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, 10.0, 2.0, 3.0, 5.0, 0.0, 11.0, -2.0, 3.0).getMax())).isCloseTo(11.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, null, 10.0, 2.0, 3.0, 5.0, null, 0.0, 11.0, -2.0, 3.0).getMax())).isCloseTo(11.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(-1.0, -8.0, -7.0, null, -11.0).getMax())).isCloseTo(-1.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)((Double)this.summarize(new Double[0]).getMax())).isNull();
    }

    @Test
    void testMin() {
        Assertions.assertThat((double)((Double)this.summarize(-1000.0, 0.0, 1.0, 50.0, 999.0, 1001.0).getMin())).isCloseTo(-1000.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, 10.0, 2.0, 3.0, 5.0, 0.0, 11.0, -2.0, 3.0).getMin())).isCloseTo(-2.0, Offset.offset((Number)0.0));
        Assertions.assertThat((double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, null, 10.0, 2.0, 3.0, 5.0, null, 0.0, 11.0, -2.0, 3.0).getMin())).isCloseTo(-2.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)((Double)this.summarize(new Double[0]).getMin())).isNull();
    }

    @Test
    void testCounts() {
        NumericColumnSummary<Double> summary = this.summarize(Double.NaN, 1.0, null, 123.0, -44.00001, Double.POSITIVE_INFINITY, 55.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, null, Double.NaN);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(11L);
        Assertions.assertThat((long)summary.getNullCount()).isEqualTo(2L);
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(9L);
        Assertions.assertThat((long)summary.getMissingCount()).isEqualTo(7L);
        Assertions.assertThat((long)summary.getNonMissingCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNanCount()).isEqualTo(2L);
        Assertions.assertThat((long)summary.getInfinityCount()).isEqualTo(3L);
    }

    protected NumericColumnSummary<Double> summarize(Double ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Double, NumericColumnSummary<Double>, DoubleSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Double> result1, NumericColumnSummary<Double> result2) {
                Assertions.assertThat((Double)((Double)result2.getMin())).isCloseTo((Double)result1.getMin(), Offset.offset((Number)0.0));
                Assertions.assertThat((Double)((Double)result2.getMax())).isCloseTo((Double)result1.getMax(), Offset.offset((Number)0.0));
                Assertions.assertThat((Double)result2.getMean()).isCloseTo(result1.getMean(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((Double)result2.getVariance()).isCloseTo(result1.getVariance(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((Double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(values);
    }
}

