/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class CompensatedSumTest {
    CompensatedSumTest() {
    }

    @Test
    void testAdd1() {
        CompensatedSum smallSum = new CompensatedSum(0.001, 0.0);
        CompensatedSum largeSum = new CompensatedSum(1000.0, 0.0);
        CompensatedSum compensatedResult1 = smallSum;
        CompensatedSum compensatedResult2 = largeSum;
        double naiveResult1 = smallSum.value();
        double naiveResult2 = largeSum.value();
        for (int i = 0; i < 10; ++i) {
            compensatedResult1 = compensatedResult1.add(smallSum);
            compensatedResult2 = compensatedResult2.add(smallSum);
            naiveResult1 += smallSum.value();
            naiveResult2 += smallSum.value();
        }
        compensatedResult1 = compensatedResult1.add(largeSum);
        compensatedResult2 = compensatedResult2.add(smallSum);
        naiveResult1 += largeSum.value();
        naiveResult2 += smallSum.value();
        Assertions.assertThat((double)compensatedResult1.value()).isCloseTo(1000.011, Offset.offset((Number)0.0));
        Assertions.assertThat((double)compensatedResult2.value()).isCloseTo(1000.011, Offset.offset((Number)0.0));
        Assertions.assertThat((double)naiveResult1).isCloseTo(1000.011, Offset.offset((Number)0.0));
        Assertions.assertThat((double)naiveResult2).isCloseTo(1000.0109999999997, Offset.offset((Number)0.0));
        Assertions.assertThat((double)compensatedResult2.value()).isCloseTo(compensatedResult1.value(), Offset.offset((Number)0.0));
        Assertions.assertThat((double)naiveResult2).isCloseTo(naiveResult1, Offset.offset((Number)1.0E-4)).isNotCloseTo(naiveResult1, Offset.offset((Number)0.0));
    }

    @Test
    void testDelta() {
        CompensatedSum compensatedResult1 = new CompensatedSum(0.001, 0.0);
        for (int i = 0; i < 10; ++i) {
            compensatedResult1 = compensatedResult1.add(0.001);
        }
        Assertions.assertThat((double)compensatedResult1.value()).isCloseTo(0.011, Offset.offset((Number)0.0));
        Assertions.assertThat((double)compensatedResult1.delta()).isCloseTo(new Double("8.673617379884035E-19"), Offset.offset((Number)0.0));
    }
}

