/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.Union;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnionTranslationTest {
    UnionTranslationTest() {
    }

    @Test
    void translateUnion2Group() {
        try {
            int parallelism = 4;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)4);
            DataSet<Tuple3<Double, StringValue, LongValue>> dataset1 = UnionTranslationTest.getSourceDataSet((ExecutionEnvironment)env, 3);
            DataSet<Tuple3<Double, StringValue, LongValue>> dataset2 = UnionTranslationTest.getSourceDataSet((ExecutionEnvironment)env, 2);
            ((GroupReduceOperator)dataset1.union(dataset2).groupBy((KeySelector & Serializable)value -> "").reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {}).returns(String.class)).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            Union unionOperator = (Union)((SingleInputOperator)sink.getInput()).getInput();
            Assertions.assertThat((Object)unionOperator.getFirstInput()).isInstanceOf(MapOperatorBase.class);
            Assertions.assertThat((Object)unionOperator.getSecondInput()).isInstanceOf(MapOperatorBase.class);
            Assertions.assertThat((int)unionOperator.getFirstInput().getParallelism()).isEqualTo(3);
            Assertions.assertThat((int)unionOperator.getSecondInput().getParallelism()).isEqualTo(2);
            Assertions.assertThat((int)unionOperator.getParallelism()).isEqualTo(-1);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateUnion3SortedGroup() {
        try {
            int parallelism = 4;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)4);
            DataSet<Tuple3<Double, StringValue, LongValue>> dataset1 = UnionTranslationTest.getSourceDataSet((ExecutionEnvironment)env, 2);
            DataSet<Tuple3<Double, StringValue, LongValue>> dataset2 = UnionTranslationTest.getSourceDataSet((ExecutionEnvironment)env, 3);
            DataSet<Tuple3<Double, StringValue, LongValue>> dataset3 = UnionTranslationTest.getSourceDataSet((ExecutionEnvironment)env, -1);
            ((GroupReduceOperator)dataset1.union(dataset2).union(dataset3).groupBy((KeySelector & Serializable)value -> "").sortGroup((KeySelector & Serializable)value -> "", Order.ASCENDING).reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {}).returns(String.class)).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            Union secondUnionOperator = (Union)((SingleInputOperator)sink.getInput()).getInput();
            Union firstUnionOperator = (Union)secondUnionOperator.getFirstInput();
            Assertions.assertThat((Object)secondUnionOperator.getSecondInput()).isInstanceOf(MapOperatorBase.class);
            Assertions.assertThat((Object)firstUnionOperator.getFirstInput()).isInstanceOf(MapOperatorBase.class);
            Assertions.assertThat((Object)firstUnionOperator.getSecondInput()).isInstanceOf(MapOperatorBase.class);
            Assertions.assertThat((int)firstUnionOperator.getFirstInput().getParallelism()).isEqualTo(2);
            Assertions.assertThat((int)firstUnionOperator.getSecondInput().getParallelism()).isEqualTo(3);
            Assertions.assertThat((int)secondUnionOperator.getSecondInput().getParallelism()).isEqualTo(-1);
            Assertions.assertThat((int)secondUnionOperator.getParallelism()).isEqualTo(-1);
            Assertions.assertThat((int)firstUnionOperator.getParallelism()).isEqualTo(-1);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    private static DataSet<Tuple3<Double, StringValue, LongValue>> getSourceDataSet(ExecutionEnvironment env, int parallelism) {
        return env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0.0, (Object)new StringValue((CharSequence)""), (Object)new LongValue(1L))}).setParallelism(parallelism);
    }
}

