/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BulkIterationTranslationTest
implements Serializable {
    BulkIterationTranslationTest() {
    }

    @Test
    void testCorrectTranslation() {
        String jobName = "Test JobName";
        int numIterations = 13;
        int defaultParallelism = 133;
        int iterationParallelism = 77;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(133);
        DataSource initialDataSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
        IterativeDataSet bulkIteration = initialDataSet.iterate(13);
        bulkIteration.setParallelism(77);
        MapOperator identity = bulkIteration.map(new IdentityMapper());
        DataSet result = bulkIteration.closeWith((DataSet)identity);
        result.output((OutputFormat)new DiscardingOutputFormat());
        result.writeAsText("/dev/null");
        Plan p = env.createProgramPlan("Test JobName");
        BulkIterationBase iteration = (BulkIterationBase)((GenericDataSinkBase)p.getDataSinks().iterator().next()).getInput();
        Assertions.assertThat((String)p.getJobName()).isEqualTo("Test JobName");
        Assertions.assertThat((int)p.getDefaultParallelism()).isEqualTo(133);
        Assertions.assertThat((int)iteration.getParallelism()).isEqualTo(77);
    }

    private static class IdentityMapper<T>
    extends RichMapFunction<T, T> {
        private IdentityMapper() {
        }

        public T map(T value) throws Exception {
            return value;
        }
    }
}

