/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.translation.PlanFilterOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Visitor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NamesTest
implements Serializable {
    NamesTest() {
    }

    @Test
    void testDefaultName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource strs = env.fromCollection(Arrays.asList("a", "b"));
        strs.filter((FilterFunction)new FilterFunction<String>(){
            private static final long serialVersionUID = 1L;

            public boolean filter(String value) throws Exception {
                return value.equals("a");
            }
        }).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        NamesTest.testForName("Filter at testDefaultName(NamesTest.java:55)", plan);
    }

    @Test
    void testGivenName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource strs = env.fromCollection(Arrays.asList("a", "b"));
        ((FilterOperator)strs.filter((FilterFunction)new FilterFunction<String>(){
            private static final long serialVersionUID = 1L;

            public boolean filter(String value) throws Exception {
                return value.equals("a");
            }
        }).name("GivenName")).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        NamesTest.testForName("GivenName", plan);
    }

    @Test
    void testJoinWith() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        ArrayList<Tuple1> strLi = new ArrayList<Tuple1>();
        strLi.add(new Tuple1((Object)"a"));
        strLi.add(new Tuple1((Object)"b"));
        DataSource strs = env.fromCollection(strLi);
        DataSource strs1 = env.fromCollection(strLi);
        strs.join((DataSet)strs1).where(new int[]{0}).equalTo(new int[]{0}).with((FlatJoinFunction)new FlatJoinFunction<Tuple1<String>, Tuple1<String>, String>(){

            public void join(Tuple1<String> first, Tuple1<String> second, Collector<String> out) throws Exception {
            }
        }).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        plan.accept(new Visitor<Operator<?>>(){

            public boolean preVisit(Operator<?> visitable) {
                if (visitable instanceof InnerJoinOperatorBase) {
                    Assertions.assertThat((String)visitable.getName()).isEqualTo("Join at testJoinWith(NamesTest.java:102)");
                }
                return true;
            }

            public void postVisit(Operator<?> visitable) {
            }
        });
    }

    private static void testForName(final String expected, Plan plan) {
        plan.accept(new Visitor<Operator<?>>(){

            public boolean preVisit(Operator<?> visitable) {
                if (visitable instanceof PlanFilterOperator) {
                    PlanFilterOperator filterOp = (PlanFilterOperator)visitable;
                    Assertions.assertThat((String)filterOp.getName()).isEqualTo(expected);
                }
                return true;
            }

            public void postVisit(Operator<?> visitable) {
            }
        });
    }
}

