/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RightOuterJoinOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    RightOuterJoinOperatorTest() {
    }

    @Test
    void testRightOuter1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where(new String[]{"f1"}).equalTo(new String[]{"f3"}).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where((KeySelector)new IntKeySelector()).equalTo((KeySelector)new IntKeySelector()).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo((KeySelector)new IntKeySelector()).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where((KeySelector)new IntKeySelector()).equalTo(new String[]{"f4"}).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2).where(new String[]{"f0"}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    @Test
    void testRightOuter7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> RightOuterJoinOperatorTest.lambda$testRightOuter7$0((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testRightOuter8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> RightOuterJoinOperatorTest.lambda$testRightOuter8$1((DataSet)ds1, (DataSet)ds2)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testRightOuter9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> RightOuterJoinOperatorTest.lambda$testRightOuter9$2((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testRightOuter10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> RightOuterJoinOperatorTest.lambda$testRightOuter10$3((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testRightOuterStrategy1() {
        this.testRightOuterStrategies(JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    @Test
    void testRightOuterStrategy2() {
        this.testRightOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
    }

    @Test
    void testRightOuterStrategy3() {
        this.testRightOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
    }

    @Test
    void testRightOuterStrategy4() {
        Assertions.assertThatThrownBy(() -> this.testRightOuterStrategies(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testRightOuterStrategy5() {
        this.testRightOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
    }

    @Test
    public void testRightOuterStrategy6() {
        this.testRightOuterStrategies(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    private void testRightOuterStrategies(JoinOperatorBase.JoinHint hint) {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.rightOuterJoin((DataSet)ds2, hint).where(new int[]{0}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    private static /* synthetic */ void lambda$testRightOuter10$3(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.rightOuterJoin(ds2).where((KeySelector)new IntKeySelector()).equalTo((KeySelector)new LongKeySelector()).with((JoinFunction)new DummyJoin());
    }

    private static /* synthetic */ void lambda$testRightOuter9$2(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.rightOuterJoin(ds2).where(new int[]{0}).equalTo(new int[]{1}).with((JoinFunction)new DummyJoin());
    }

    private static /* synthetic */ void lambda$testRightOuter8$1(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.rightOuterJoin(ds2).where(new int[]{1}).equalTo(new String[]{"f5"}).with((JoinFunction)new DummyJoin());
    }

    private static /* synthetic */ void lambda$testRightOuter7$0(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.rightOuterJoin(ds2).where(new int[]{5}).equalTo(new int[]{0}).with((JoinFunction)new DummyJoin());
    }

    private static class LongKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Long> {
        private LongKeySelector() {
        }

        public Long getKey(Tuple5<Integer, Long, String, Long, Integer> v) throws Exception {
            return (Long)v.f1;
        }
    }

    private static class IntKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Integer> {
        private IntKeySelector() {
        }

        public Integer getKey(Tuple5<Integer, Long, String, Long, Integer> v) throws Exception {
            return (Integer)v.f0;
        }
    }

    private static class DummyJoin
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Long> {
        private DummyJoin() {
        }

        public Long join(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return 1L;
        }
    }
}

