/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GroupingTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.createTypeInfo(CustomType.class), BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();
    private final List<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomData = new ArrayList<Tuple4<Integer, Long, CustomType, Long[]>>();
    private final List<Tuple2<byte[], byte[]>> byteArrayData = new ArrayList<Tuple2<byte[], byte[]>>();

    GroupingTest() {
    }

    @Test
    void testGroupByKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyFields2$0((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupByKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyFields3$1((DataSet)customDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupByKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyFields4$2((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testGroupByKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyFields5$3((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testGroupByKeyFieldsOnPrimitiveArray() {
        this.byteArrayData.add((Tuple2<byte[], byte[]>)new Tuple2((Object)new byte[]{0}, (Object)new byte[]{1}));
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.byteArrayData);
        tupleDs.groupBy(new int[]{0});
    }

    @Test
    void testGroupByKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyExpressions2$4((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupByKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeyExpressions3$5((DataSet)customDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupByKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Assertions.assertThatThrownBy(() -> {
            DataSource ds = env.fromCollection(this.customTypeData);
            ds.groupBy(new String[]{"myNonExistent"});
        }).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGroupByKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Assertions.assertThatThrownBy(() -> {
            DataSource ds = env.fromCollection(this.customTypeData);
            ds.groupBy(new String[]{"nested.myNonExistent"});
        }).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGroupByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector & Serializable)value -> value.myLong);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, Long>>(){

                public Tuple2<Integer, Long> getKey(CustomType value) {
                    return new Tuple2((Object)value.myInt, (Object)value.myLong);
                }
            });
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, CustomType>(){

                public CustomType getKey(CustomType value) {
                    return value;
                }
            });
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, CustomType>>(){

                public Tuple2<Integer, CustomType> getKey(CustomType value) {
                    return new Tuple2((Object)value.myInt, (Object)value);
                }
            });
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupByKeySelector5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupByKeySelector5$8((DataSet)customDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupSortKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortKeyFields2$9((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testGroupSortKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> this.lambda$testGroupSortKeyFields3$10((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortKeyFields4$11((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortKeyFields5$12((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testChainedGroupSortKeyFields() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING).sortGroup(2, Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupSortByKeyExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f1", Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupSortByKeyExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2.myString", Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupSortByKeyExpression3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2.myString", Order.ASCENDING).sortGroup("f1", Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupSortByKeyExpression4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortByKeyExpression4$13((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortByKeyExpression5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortByKeyExpression5$14((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortByKeyExpression6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortByKeyExpression6$15((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long>(){

            public Long getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long)value.f1;
            }
        }).sortGroup((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Integer>(){

            public Integer getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Integer)value.f0;
            }
        }, Order.ASCENDING);
    }

    @Test
    void testGroupSortByKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortByKeySelector2$16((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupSortByKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupSortByKeySelector3$17((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupingAtomicType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 1, 2, 0, 0});
        dataSet.groupBy(new String[]{"*"});
    }

    @Test
    void testGroupAtomicTypeWithInvalid1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 2, 3});
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupAtomicTypeWithInvalid1$18((DataSet)dataSet)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupAtomicTypeWithInvalid2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 2, 3});
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupAtomicTypeWithInvalid2$19((DataSet)dataSet)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupAtomicTypeWithInvalid3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        Assertions.assertThatThrownBy(() -> GroupingTest.lambda$testGroupAtomicTypeWithInvalid3$20((DataSet)dataSet)).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testGroupAtomicTypeWithInvalid3$20(DataSet dataSet) throws Throwable {
        dataSet.groupBy(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testGroupAtomicTypeWithInvalid2$19(DataSet dataSet) throws Throwable {
        dataSet.groupBy(new String[]{"invalidField"});
    }

    private static /* synthetic */ void lambda$testGroupAtomicTypeWithInvalid1$18(DataSet dataSet) throws Throwable {
        dataSet.groupBy(new String[]{"*", "invalidField"});
    }

    private static /* synthetic */ void lambda$testGroupSortByKeySelector3$17(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy((KeySelector & Serializable)value -> (Long)value.f1).sortGroup((KeySelector & Serializable)value -> (Long[])value.f3, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortByKeySelector2$16(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy((KeySelector & Serializable)value -> (Long)value.f1).sortGroup((KeySelector & Serializable)value -> (CustomType)value.f2, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortByKeyExpression6$15(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f3", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortByKeyExpression5$14(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f1", Order.ASCENDING).sortGroup("f2", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortByKeyExpression4$13(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortKeyFields5$12(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{0}).sortGroup(3, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortKeyFields4$11(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{0}).sortGroup(2, Order.ASCENDING);
    }

    private /* synthetic */ void lambda$testGroupSortKeyFields3$10(DataSet longDs) throws Throwable {
        longDs.groupBy((KeySelector)new KeySelector<Long, Long>(){
            private static final long serialVersionUID = 1L;

            public Long getKey(Long value) {
                return value;
            }
        }).sortGroup(0, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupSortKeyFields2$9(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{0}).sortGroup(5, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testGroupByKeySelector5$8(DataSet customDs) throws Throwable {
        customDs.groupBy((KeySelector & Serializable)value -> new CustomType2());
    }

    private static /* synthetic */ void lambda$testGroupByKeyExpressions3$5(DataSet customDs) throws Throwable {
        customDs.groupBy(new int[]{0});
    }

    private static /* synthetic */ void lambda$testGroupByKeyExpressions2$4(DataSet longDs) throws Throwable {
        longDs.groupBy(new String[]{"myInt"});
    }

    private static /* synthetic */ void lambda$testGroupByKeyFields5$3(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testGroupByKeyFields4$2(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{5});
    }

    private static /* synthetic */ void lambda$testGroupByKeyFields3$1(DataSet customDs) throws Throwable {
        customDs.groupBy(new int[]{0});
    }

    private static /* synthetic */ void lambda$testGroupByKeyFields2$0(DataSet longDs) throws Throwable {
        longDs.groupBy(new int[]{0});
    }

    public static class CustomType2
    implements Serializable {
        public int myInt;
        public Integer[] myIntArray;
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nest nested;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }

        public static class Nest {
            public int myInt;
        }
    }
}

