/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DistinctOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();

    DistinctOperatorTest() {
    }

    @Test
    void testDistinctByKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.distinct(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDistinctByKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> DistinctOperatorTest.lambda$testDistinctByKeyFields2$0((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testDistinctByKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        Assertions.assertThatThrownBy(() -> DistinctOperatorTest.lambda$testDistinctByKeyFields3$1((DataSet)customDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testDistinctByKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.distinct();
    }

    @Test
    void testDistinctByKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.distinct();
    }

    @Test
    void testDistinctByKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> DistinctOperatorTest.lambda$testDistinctByKeyFields6$2((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testDistinctByKeyFields7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        try {
            longDs.distinct(new String[]{"*"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDistinctByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.distinct((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDistinctByKeyIndices1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        try {
            DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
            longDs.distinct();
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDistinctOnNotKeyDataType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        NotComparable a = new NotComparable();
        ArrayList<NotComparable> l = new ArrayList<NotComparable>();
        l.add(a);
        DataSource ds = env.fromCollection(l);
        Assertions.assertThatThrownBy(() -> DistinctOperatorTest.lambda$testDistinctOnNotKeyDataType$3((DataSet)ds)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testDistinctOnNotKeyDataTypeOnSelectAllChar() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        NotComparable a = new NotComparable();
        ArrayList<NotComparable> l = new ArrayList<NotComparable>();
        l.add(a);
        DataSource ds = env.fromCollection(l);
        Assertions.assertThatThrownBy(() -> DistinctOperatorTest.lambda$testDistinctOnNotKeyDataTypeOnSelectAllChar$4((DataSet)ds)).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testDistinctOnNotKeyDataTypeOnSelectAllChar$4(DataSet ds) throws Throwable {
        DistinctOperator reduceDs = ds.distinct(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testDistinctOnNotKeyDataType$3(DataSet ds) throws Throwable {
        DistinctOperator reduceDs = ds.distinct();
    }

    private static /* synthetic */ void lambda$testDistinctByKeyFields6$2(DataSet tupleDs) throws Throwable {
        tupleDs.distinct(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testDistinctByKeyFields3$1(DataSet customDs) throws Throwable {
        customDs.distinct(new int[]{0});
    }

    private static /* synthetic */ void lambda$testDistinctByKeyFields2$0(DataSet longDs) throws Throwable {
        longDs.distinct(new int[]{0});
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }

    static class NotComparable {
        public List<Integer> myInts;

        NotComparable() {
        }
    }
}

