/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class CrossOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<CustomType> customTypeData = new ArrayList<CustomType>();

    CrossOperatorTest() {
    }

    @BeforeAll
    static void insertCustomData() {
        customTypeData.add(new CustomType());
    }

    @Test
    void testCrossProjection1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection21() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection22() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection23() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection24() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection25() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection26() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection27() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCrossProjection8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection8$0((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection28() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection28$1((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection9$2((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection29() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection29$3((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{2});
    }

    @Test
    void testCrossProjection30() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection30$4((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    void testCrossProjection11() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{2});
    }

    @Test
    void testCrossProjection31() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection31$5((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    void testCrossProjection12() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{2}).projectFirst(new int[]{1});
    }

    @Test
    void testCrossProjection32() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection32$6((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection13() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection13$7((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCrossProjection14() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CrossOperatorTest.lambda$testCrossProjection14$8((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    private static /* synthetic */ void lambda$testCrossProjection14$8(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectFirst(new int[]{0}).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCrossProjection13$7(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectSecond(new int[]{0}).projectFirst(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCrossProjection32$6(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectSecond(new int[]{2}).projectFirst(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testCrossProjection31$5(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectSecond(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testCrossProjection30$4(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectFirst(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testCrossProjection29$3(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCrossProjection9$2(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCrossProjection28$1(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectFirst(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCrossProjection8$0(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.cross(ds2).projectFirst(new int[]{5});
    }

    static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

