/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionEnvironmentTest {
    ExecutionEnvironmentTest() {
    }

    @Test
    void testConcurrentSetContext() throws Exception {
        int numThreads = 20;
        final CountDownLatch waitingThreadCount = new CountDownLatch(numThreads);
        final OneShotLatch latch = new OneShotLatch();
        ArrayList<1> threads = new ArrayList<1>();
        for (int x = 0; x < numThreads; ++x) {
            CheckedThread checkedThread = new CheckedThread(){

                public void go() {
                    ExecutionEnvironment preparedEnvironment = new ExecutionEnvironment();
                    ExecutionEnvironment.initializeContextEnvironment(() -> preparedEnvironment);
                    try {
                        waitingThreadCount.countDown();
                        latch.awaitQuietly();
                        Assertions.assertThat((Object)ExecutionEnvironment.getExecutionEnvironment()).isSameAs((Object)preparedEnvironment);
                    }
                    finally {
                        ExecutionEnvironment.resetContextEnvironment();
                    }
                }
            };
            checkedThread.start();
            threads.add(checkedThread);
        }
        waitingThreadCount.await();
        latch.trigger();
        for (CheckedThread checkedThread : threads) {
            checkedThread.sync();
        }
    }
}

