/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InnerJoinOperatorBaseTest
implements Serializable {
    InnerJoinOperatorBaseTest() {
    }

    @Test
    void testTupleBaseJoiner() {
        FlatJoinFunction & Serializable joiner = (FlatJoinFunction & Serializable)(first, second, out) -> {
            Assertions.assertThat((String)((String)second.f1)).isEqualTo((String)first.f0);
            Assertions.assertThat((Integer)((Integer)second.f0)).isEqualTo(first.f2);
            out.collect((Object)new Tuple2(first.f1, (Object)((Integer)second.f0).toString()));
        };
        TupleTypeInfo leftTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Double.class, Integer.class});
        TupleTypeInfo rightTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, String.class});
        TupleTypeInfo outTypeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Double.class, String.class});
        int[] leftKeys = new int[]{0, 2};
        int[] rightKeys = new int[]{1, 0};
        String taskName = "Collection based tuple joiner";
        BinaryOperatorInformation binaryOpInfo = new BinaryOperatorInformation((TypeInformation)leftTypeInfo, (TypeInformation)rightTypeInfo, (TypeInformation)outTypeInfo);
        InnerJoinOperatorBase base = new InnerJoinOperatorBase((FlatJoinFunction)joiner, binaryOpInfo, leftKeys, rightKeys, "Collection based tuple joiner");
        ArrayList<Tuple3> inputData1 = new ArrayList<Tuple3>(Arrays.asList(new Tuple3((Object)"foo", (Object)42.0, (Object)1), new Tuple3((Object)"bar", (Object)1.0, (Object)2), new Tuple3((Object)"bar", (Object)2.0, (Object)3), new Tuple3((Object)"foobar", (Object)3.0, (Object)4), new Tuple3((Object)"bar", (Object)3.0, (Object)3)));
        ArrayList<Tuple2> inputData2 = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)3, (Object)"bar"), new Tuple2((Object)4, (Object)"foobar"), new Tuple2((Object)2, (Object)"foo")));
        HashSet<Tuple2> expected = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)2.0, (Object)"3"), new Tuple2((Object)3.0, (Object)"3"), new Tuple2((Object)3.0, (Object)"4")));
        try {
            TaskInfo taskInfo = new TaskInfo("op", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultSafe = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assertions.assertThat((List)resultSafe).containsExactlyInAnyOrderElementsOf(expected);
            Assertions.assertThat((List)resultRegular).containsExactlyInAnyOrderElementsOf(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

