/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionExecutionIterationTest
implements Serializable {
    CollectionExecutionIterationTest() {
    }

    @Test
    void testBulkIteration() {
        try {
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            IterativeDataSet iteration = env.fromElements((Object[])new Integer[]{1}).iterate(10);
            DataSet result = iteration.closeWith((DataSet)iteration.map((MapFunction)new AddSuperstepNumberMapper()));
            ArrayList collected = new ArrayList();
            result.output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            Assertions.assertThat(collected).containsExactly((Object[])new Integer[]{56});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testBulkIterationWithTerminationCriterion() {
        try {
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            IterativeDataSet iteration = env.fromElements((Object[])new Integer[]{1}).iterate(100);
            MapOperator iterationResult = iteration.map((MapFunction)new AddSuperstepNumberMapper());
            FilterOperator terminationCriterion = iterationResult.filter((FilterFunction & Serializable)value -> value < 50);
            ArrayList collected = new ArrayList();
            iteration.closeWith((DataSet)iterationResult, (DataSet)terminationCriterion).output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            Assertions.assertThat(collected).containsExactly((Object[])new Integer[]{56});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDeltaIteration() {
        try {
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            DataSource solInput = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1, (Object)0), new Tuple2((Object)2, (Object)0), new Tuple2((Object)3, (Object)0), new Tuple2((Object)4, (Object)0)});
            DataSource workInput = env.fromElements((Object[])new Tuple1[]{new Tuple1((Object)1), new Tuple1((Object)2), new Tuple1((Object)3), new Tuple1((Object)4)});
            DeltaIteration iteration = solInput.iterateDelta((DataSet)workInput, 10, new int[]{0});
            JoinOperator.EquiJoin solDelta = iteration.getSolutionSet().join((DataSet)iteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<Tuple2<Integer, Integer>, Tuple1<Integer>, Tuple2<Integer, Integer>>(){

                public Tuple2<Integer, Integer> join(Tuple2<Integer, Integer> first, Tuple1<Integer> second) throws Exception {
                    return new Tuple2(first.f0, (Object)((Integer)first.f1 + 1));
                }
            });
            FlatMapOperator nextWorkset = solDelta.flatMap((FlatMapFunction)new FlatMapFunction<Tuple2<Integer, Integer>, Tuple1<Integer>>(){

                public void flatMap(Tuple2<Integer, Integer> in, Collector<Tuple1<Integer>> out) throws Exception {
                    if ((Integer)in.f1 < (Integer)in.f0) {
                        out.collect((Object)new Tuple1(in.f0));
                    }
                }
            });
            ArrayList collected = new ArrayList();
            iteration.closeWith((DataSet)solDelta, (DataSet)nextWorkset).output((OutputFormat)new LocalCollectionOutputFormat(collected));
            env.execute();
            for (Tuple2 t : collected) {
                Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(t.f0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static class AddSuperstepNumberMapper
    extends RichMapFunction<Integer, Integer> {
        private AddSuperstepNumberMapper() {
        }

        public Integer map(Integer value) {
            int superstep = this.getIterationRuntimeContext().getSuperstepNumber();
            return value + superstep;
        }
    }
}

