/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.io.BinaryInputFormat;
import org.apache.flink.api.common.io.BinaryOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class SequentialFormatTestBase<T> {
    @Parameter
    public int numberOfTuples;
    @Parameter(value=1)
    public long blockSize;
    @Parameter(value=2)
    public int parallelism;
    @Parameter(value=3)
    public int[] rawDataSizes;
    protected File tempFile;

    @BeforeEach
    void calcRawDataSize() throws IOException {
        int recordIndex = 0;
        for (int fileIndex = 0; fileIndex < this.parallelism; ++fileIndex) {
            ByteCounter byteCounter = new ByteCounter();
            int fileCount = 0;
            while (fileCount < this.getNumberOfTuplesPerFile(fileIndex)) {
                this.writeRecord(this.getRecord(recordIndex), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)byteCounter));
                ++fileCount;
                ++recordIndex;
            }
            this.rawDataSizes[fileIndex] = byteCounter.getLength();
        }
    }

    @TestTemplate
    void checkInputSplits() throws IOException {
        FileInputSplit[] inputSplits = this.createInputFormat().createInputSplits(0);
        Arrays.sort(inputSplits, new InputSplitSorter());
        int splitIndex = 0;
        for (int fileIndex = 0; fileIndex < this.parallelism; ++fileIndex) {
            ArrayList<FileInputSplit> sameFileSplits = new ArrayList<FileInputSplit>();
            Path lastPath = inputSplits[splitIndex].getPath();
            while (splitIndex < inputSplits.length && inputSplits[splitIndex].getPath().equals((Object)lastPath)) {
                sameFileSplits.add(inputSplits[splitIndex]);
                ++splitIndex;
            }
            Assertions.assertThat((int)this.getExpectedBlockCount(fileIndex)).isEqualTo(sameFileSplits.size());
            long lastBlockLength = (long)this.rawDataSizes[fileIndex] % (this.blockSize - (long)this.getInfoSize()) + (long)this.getInfoSize();
            for (int index = 0; index < sameFileSplits.size(); ++index) {
                Assertions.assertThat((long)(this.blockSize * (long)index)).isEqualTo(((FileInputSplit)sameFileSplits.get(index)).getStart());
                if (index >= sameFileSplits.size() - 1) continue;
                Assertions.assertThat((long)this.blockSize).isEqualTo(((FileInputSplit)sameFileSplits.get(index)).getLength());
            }
            Assertions.assertThat((long)lastBlockLength).isEqualTo(((FileInputSplit)sameFileSplits.get(sameFileSplits.size() - 1)).getLength());
        }
    }

    @TestTemplate
    void checkRead() throws Exception {
        BinaryInputFormat<T> input = this.createInputFormat();
        FileInputSplit[] inputSplits = input.createInputSplits(0);
        Arrays.sort(inputSplits, new InputSplitSorter());
        int readCount = 0;
        for (FileInputSplit inputSplit : inputSplits) {
            input.open(inputSplit);
            input.reopen(inputSplit, input.getCurrentState());
            T record = this.createInstance();
            while (!input.reachedEnd()) {
                if (input.nextRecord(record) == null) continue;
                this.checkEquals(this.getRecord(readCount), record);
                if (!input.reachedEnd()) {
                    Tuple2 state = input.getCurrentState();
                    input = this.createInputFormat();
                    input.reopen(inputSplit, state);
                }
                ++readCount;
            }
        }
        Assertions.assertThat((int)this.numberOfTuples).isEqualTo(readCount);
    }

    @TestTemplate
    void checkStatistics() {
        BinaryInputFormat<T> input = this.createInputFormat();
        BinaryInputFormat.SequentialStatistics statistics = input.getStatistics(null);
        Assertions.assertThat((int)this.numberOfTuples).isEqualTo(statistics.getNumberOfRecords());
    }

    @AfterEach
    void cleanup() {
        this.deleteRecursively(this.tempFile);
    }

    private void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.deleteRecursively(subFile);
            }
        } else {
            file.delete();
        }
    }

    @BeforeEach
    void writeTuples() throws IOException {
        this.tempFile = File.createTempFile("BinaryInputFormat", null);
        this.tempFile.deleteOnExit();
        Configuration configuration = new Configuration();
        configuration.setLong("output.block_size", this.blockSize);
        if (this.parallelism == 1) {
            BinaryOutputFormat<T> output = this.createOutputFormat(this.tempFile.toURI().toString(), configuration);
            for (int index = 0; index < this.numberOfTuples; ++index) {
                output.writeRecord(this.getRecord(index));
            }
            output.close();
        } else {
            this.tempFile.delete();
            this.tempFile.mkdir();
            int recordIndex = 0;
            for (int fileIndex = 0; fileIndex < this.parallelism; ++fileIndex) {
                BinaryOutputFormat<T> output = this.createOutputFormat(this.tempFile.toURI() + "/" + (fileIndex + 1), configuration);
                int fileCount = 0;
                while (fileCount < this.getNumberOfTuplesPerFile(fileIndex)) {
                    output.writeRecord(this.getRecord(recordIndex));
                    ++fileCount;
                    ++recordIndex;
                }
                output.close();
            }
        }
    }

    private int getNumberOfTuplesPerFile(int fileIndex) {
        return this.numberOfTuples / this.parallelism;
    }

    @TestTemplate
    void checkLength() {
        Object[] objectArray;
        if (this.tempFile.isDirectory()) {
            objectArray = this.tempFile.listFiles();
        } else {
            File[] fileArray = new File[1];
            objectArray = fileArray;
            fileArray[0] = this.tempFile;
        }
        Object[] files = objectArray;
        Arrays.sort(files);
        for (int fileIndex = 0; fileIndex < this.parallelism; ++fileIndex) {
            long lastBlockLength = (long)this.rawDataSizes[fileIndex] % (this.blockSize - (long)this.getInfoSize());
            long expectedLength = (long)(this.getExpectedBlockCount(fileIndex) - 1) * this.blockSize + (long)this.getInfoSize() + lastBlockLength;
            Assertions.assertThat((long)expectedLength).isEqualTo(((File)files[fileIndex]).length());
        }
    }

    protected abstract BinaryInputFormat<T> createInputFormat();

    protected abstract BinaryOutputFormat<T> createOutputFormat(String var1, Configuration var2) throws IOException;

    protected abstract int getInfoSize();

    protected abstract T getRecord(int var1);

    protected abstract T createInstance();

    protected abstract void writeRecord(T var1, DataOutputView var2) throws IOException;

    protected abstract void checkEquals(T var1, T var2);

    private int getExpectedBlockCount(int fileIndex) {
        int expectedBlockCount = (int)Math.ceil((double)this.rawDataSizes[fileIndex] / (double)(this.blockSize - (long)this.getInfoSize()));
        return expectedBlockCount;
    }

    @Parameters
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int parallelism = 1; parallelism <= 2; ++parallelism) {
            params.add(new Object[]{100, Long.MIN_VALUE, parallelism, new int[parallelism]});
            params.add(new Object[]{100, 1000, parallelism, new int[parallelism]});
            params.add(new Object[]{100, 0x100000, parallelism, new int[parallelism]});
            params.add(new Object[]{10000, 1000, parallelism, new int[parallelism]});
            params.add(new Object[]{10000, 0x100000, parallelism, new int[parallelism]});
        }
        return params;
    }

    private static final class ByteCounter
    extends OutputStream {
        int length = 0;

        private ByteCounter() {
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.length;
        }
    }

    private static class InputSplitSorter
    implements Comparator<FileInputSplit> {
        private InputSplitSorter() {
        }

        @Override
        public int compare(FileInputSplit o1, FileInputSplit o2) {
            int pathOrder = o1.getPath().getName().compareTo(o2.getPath().getName());
            return pathOrder == 0 ? Long.signum(o1.getStart() - o2.getStart()) : pathOrder;
        }
    }
}

