/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.DefaultFileFilter;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public class NonSplittingRecursiveEnumerator
implements FileEnumerator {
    private final Predicate<Path> fileFilter;
    private final char[] currentId = "0000000000".toCharArray();

    public NonSplittingRecursiveEnumerator() {
        this(new DefaultFileFilter());
    }

    public NonSplittingRecursiveEnumerator(Predicate<Path> fileFilter) {
        this.fileFilter = (Predicate)Preconditions.checkNotNull(fileFilter);
    }

    @Override
    public Collection<FileSourceSplit> enumerateSplits(Path[] paths, int minDesiredSplits) throws IOException {
        ArrayList<FileSourceSplit> splits = new ArrayList<FileSourceSplit>();
        for (Path path : paths) {
            FileSystem fs = path.getFileSystem();
            FileStatus status = fs.getFileStatus(path);
            this.addSplitsForPath(status, fs, splits);
        }
        return splits;
    }

    private void addSplitsForPath(FileStatus fileStatus, FileSystem fs, ArrayList<FileSourceSplit> target) throws IOException {
        FileStatus[] containedFiles;
        if (!this.fileFilter.test(fileStatus.getPath())) {
            return;
        }
        if (!fileStatus.isDir()) {
            this.convertToSourceSplits(fileStatus, fs, target);
            return;
        }
        for (FileStatus containedStatus : containedFiles = fs.listStatus(fileStatus.getPath())) {
            this.addSplitsForPath(containedStatus, fs, target);
        }
    }

    protected void convertToSourceSplits(FileStatus file, FileSystem fs, List<FileSourceSplit> target) throws IOException {
        String[] hosts = NonSplittingRecursiveEnumerator.getHostsFromBlockLocations(fs.getFileBlockLocations(file, 0L, file.getLen()));
        target.add(new FileSourceSplit(this.getNextId(), file.getPath(), 0L, file.getLen(), file.getModificationTime(), file.getLen(), hosts));
    }

    protected final String getNextId() {
        NonSplittingRecursiveEnumerator.incrementCharArrayByOne(this.currentId, this.currentId.length - 1);
        return new String(this.currentId);
    }

    private static String[] getHostsFromBlockLocations(BlockLocation[] blockLocations) throws IOException {
        if (blockLocations.length == 0) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        if (blockLocations.length == 1) {
            return blockLocations[0].getHosts();
        }
        LinkedHashSet<String> allHosts = new LinkedHashSet<String>();
        for (BlockLocation block : blockLocations) {
            allHosts.addAll(Arrays.asList(block.getHosts()));
        }
        return allHosts.toArray(new String[allHosts.size()]);
    }

    private static void incrementCharArrayByOne(char[] array, int pos) {
        int c = array[pos];
        if ((c = (char)(c + '\u0001')) > 57) {
            c = 48;
            NonSplittingRecursiveEnumerator.incrementCharArrayByOne(array, pos - 1);
        }
        array[pos] = c;
    }
}

