/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaModifier;
import java.lang.annotation.Annotation;

public class JavaFieldPredicates {
    public static DescribedPredicate<JavaField> isPublic() {
        return DescribedPredicate.describe((String)"public", field -> field.getModifiers().contains(JavaModifier.PUBLIC));
    }

    public static DescribedPredicate<JavaField> isStatic() {
        return DescribedPredicate.describe((String)"static", field -> field.getModifiers().contains(JavaModifier.STATIC));
    }

    public static DescribedPredicate<JavaField> isNotStatic() {
        return DescribedPredicate.describe((String)"not static", field -> !field.getModifiers().contains(JavaModifier.STATIC));
    }

    public static DescribedPredicate<JavaField> isFinal() {
        return DescribedPredicate.describe((String)"final", field -> field.getModifiers().contains(JavaModifier.FINAL));
    }

    public static DescribedPredicate<JavaField> ofType(Class<?> clazz) {
        return DescribedPredicate.describe((String)("of type " + clazz.getSimpleName()), field -> field.getRawType().isEquivalentTo(clazz));
    }

    public static DescribedPredicate<JavaField> isAssignableTo(Class<?> clazz) {
        return DescribedPredicate.describe((String)("is assignable to " + clazz.getSimpleName()), field -> field.getRawType().isAssignableTo(clazz));
    }

    public static DescribedPredicate<JavaField> annotatedWith(Class<? extends Annotation> annotationType) {
        return DescribedPredicate.describe((String)("annotated with @" + annotationType.getSimpleName()), field -> field.getAnnotations().stream().map(annotation -> annotation.getRawType().isEquivalentTo(annotationType)).reduce(false, Boolean::logicalOr));
    }
}

