/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.HessianException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class RecordUtil {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private static final ClassValue<Constructor<?>> CONSTRUCTOR;
    private static final ClassValue<RecordComponent[]> RECORD_COMPONENTS;

    public static boolean isRecord(Class<?> type) {
        if (IS_RECORD == null) {
            return false;
        }
        try {
            return (Boolean)IS_RECORD.invoke(type, new Object[0]);
        }
        catch (Throwable t) {
            throw new HessianException("Could not determine type (" + type + ")");
        }
    }

    public static RecordComponent[] getRecordComponents(Class<?> type) {
        return RECORD_COMPONENTS.get(type);
    }

    private static <T> RecordComponent[] recordComponents(Class<T> type, Comparator<RecordComponent> comparator) {
        try {
            Object[] rawComponents = (Object[])GET_RECORD_COMPONENTS.invoke(type, new Object[0]);
            RecordComponent[] recordComponents = new RecordComponent[rawComponents.length];
            for (int i = 0; i < rawComponents.length; ++i) {
                Object comp = rawComponents[i];
                recordComponents[i] = new RecordComponent(type, (String)GET_NAME.invoke(comp, new Object[0]), (Class)GET_TYPE.invoke(comp, new Object[0]), i);
            }
            if (comparator != null) {
                Arrays.sort(recordComponents, comparator);
            }
            return recordComponents;
        }
        catch (Throwable t) {
            throw new HessianException("Could not retrieve record components (" + type.getName() + ")", t);
        }
    }

    private <T> T invokeCanonicalConstructor(Class<? extends T> recordType, Object[] args) {
        try {
            return (T)CONSTRUCTOR.get(recordType).newInstance(args);
        }
        catch (Throwable t) {
            throw new HessianException("Could not construct type (" + recordType.getName() + ")", t);
        }
    }

    public static Constructor<?> getCanonicalConstructor(Class recordType) {
        return CONSTRUCTOR.get(recordType);
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, RecordComponent[] recordComponents) {
        try {
            Class[] paramTypes = (Class[])Arrays.stream(recordComponents).map(RecordComponent::type).toArray(Class[]::new);
            return RecordUtil.getCanonicalConstructor(recordType, paramTypes);
        }
        catch (Throwable t) {
            throw new HessianException("Could not retrieve record canonical constructor (" + recordType.getName() + ")", t);
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, Class<?>[] paramTypes) throws NoSuchMethodException {
        Constructor<T> canonicalConstructor;
        try {
            canonicalConstructor = recordType.getConstructor(paramTypes);
            if (!canonicalConstructor.isAccessible()) {
                canonicalConstructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            canonicalConstructor = recordType.getDeclaredConstructor(paramTypes);
            canonicalConstructor.setAccessible(true);
        }
        return canonicalConstructor;
    }

    static {
        Method getType;
        Method getName;
        Method getRecordComponents;
        Method isRecord;
        CONSTRUCTOR = new ClassValue<Constructor<?>>(){

            @Override
            protected Constructor<?> computeValue(Class<?> clazz) {
                RecordComponent[] components = RecordUtil.recordComponents(clazz, Comparator.comparing(RecordComponent::index));
                return RecordUtil.getCanonicalConstructor(clazz, components);
            }
        };
        RECORD_COMPONENTS = new ClassValue<RecordComponent[]>(){

            @Override
            protected RecordComponent[] computeValue(Class<?> type) {
                return RecordUtil.recordComponents(type, Comparator.comparing(RecordComponent::index));
            }
        };
        try {
            Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
            isRecord = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            getName = c.getMethod("getName", new Class[0]);
            getType = c.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            isRecord = null;
            getRecordComponents = null;
            getName = null;
            getType = null;
        }
        IS_RECORD = isRecord;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_NAME = getName;
        GET_TYPE = getType;
    }

    public static final class RecordComponent {
        private final Class<?> recordType;
        private final String name;
        private final Class<?> type;
        private final int index;
        private final Method getter;

        RecordComponent(Class<?> recordType, String name, Class<?> type, int index) {
            this.recordType = recordType;
            this.name = name;
            this.type = type;
            this.index = index;
            try {
                this.getter = recordType.getDeclaredMethod(name, new Class[0]);
                if (!this.getter.isAccessible()) {
                    this.getter.setAccessible(true);
                }
            }
            catch (Exception t) {
                throw new HessianException("Could not retrieve record component getter (" + recordType.getName() + ")", t);
            }
        }

        public String name() {
            return this.name;
        }

        public Class<?> type() {
            return this.type;
        }

        public int index() {
            return this.index;
        }

        public Object getValue(Object recordObject) {
            try {
                return this.getter.invoke(recordObject, new Object[0]);
            }
            catch (Exception t) {
                throw new HessianException("Could not retrieve record component value (" + this.recordType.getName() + ")", t);
            }
        }
    }
}

