/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;

public abstract class RequestFacade<T> {
    protected Map<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
    protected Map<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
    protected String path;
    protected T request;
    protected byte[] body = new byte[0];
    protected ServiceDeployer serviceDeployer;

    public RequestFacade(T request) {
        this.request = request;
        this.initHeaders();
        this.initParameters();
        this.parseBody();
    }

    public RequestFacade(T request, ServiceDeployer serviceDeployer) {
        this(request);
        this.serviceDeployer = serviceDeployer;
    }

    protected void initHeaders() {
    }

    protected void initParameters() {
        String requestURI = this.getRequestURI();
        if (requestURI != null && requestURI.contains("?")) {
            String[] split;
            String queryString = requestURI.substring(requestURI.indexOf("?") + 1);
            this.path = requestURI.substring(0, requestURI.indexOf("?"));
            for (String params : split = queryString.split("&")) {
                int index = params.indexOf("=");
                if (index <= 0) continue;
                String name = params.substring(0, index);
                String value = params.substring(index + 1);
                if (StringUtils.isEmpty((String)name)) continue;
                ArrayList<String> values = this.parameters.get(name);
                if (values == null) {
                    values = new ArrayList();
                    this.parameters.put(name, values);
                }
                values.add(value);
            }
        } else {
            this.path = requestURI;
        }
    }

    public T getRequest() {
        return this.request;
    }

    public abstract String getHeader(String var1);

    public abstract Enumeration<String> getHeaders(String var1);

    public abstract Enumeration<String> getHeaderNames();

    public abstract String getMethod();

    public abstract String getPath();

    public abstract String getContextPath();

    public abstract String getRequestURI();

    public abstract String getParameter(String var1);

    public abstract Enumeration<String> getParameterNames();

    public abstract String[] getParameterValues(String var1);

    public abstract Map<String, String[]> getParameterMap();

    public abstract String getRemoteAddr();

    public abstract String getRemoteHost();

    public abstract int getRemotePort();

    public abstract String getLocalAddr();

    public abstract String getLocalHost();

    public abstract int getLocalPort();

    public abstract byte[] getInputStream() throws IOException;

    protected abstract void parseBody();

    public ServiceDeployer getServiceDeployer() {
        return this.serviceDeployer;
    }
}

