/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.RestProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyServer;
import org.apache.dubbo.rpc.protocol.rest.netty.RestHttpRequestDecoder;
import org.apache.dubbo.rpc.protocol.rest.netty.UnSharedHandlerCreator;
import org.apache.dubbo.rpc.protocol.rest.netty.ssl.SslServerTlsHandler;

public class NettyHttpRestServer
implements RestProtocolServer {
    private ServiceDeployer serviceDeployer = new ServiceDeployer();
    private NettyServer server = this.getNettyServer();
    private String address;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    protected NettyServer getNettyServer() {
        return new NettyServer();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void close() {
        this.server.stop();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void start(URL url) {
        this.registerExtension(url);
        String bindIp = url.getParameter("bind.ip", url.getHost());
        if (!url.isAnyHost() && NetUtils.isValidLocalHost((String)bindIp)) {
            this.server.setHostname(bindIp);
        }
        this.server.setPort(url.getParameter("bind.port", url.getPort()));
        this.server.setChildChannelOptions(this.getChildChannelOptionMap(url));
        this.server.setChannelOptions(this.getChannelOptionMap(url));
        this.server.setUnSharedHandlerCallBack(this.getUnSharedHttpChannelHandlers());
        this.server.setChannelHandlers(this.getChannelHandlers(url));
        this.server.setIoWorkerCount(url.getParameter("iothreads", Constants.DEFAULT_IO_THREADS));
        this.server.start(url);
    }

    private UnSharedHandlerCreator getUnSharedHttpChannelHandlers() {
        return new UnSharedHandlerCreator(){

            @Override
            public List<ChannelHandler> getUnSharedHandlers(URL url) {
                return Arrays.asList(new ChannelHandler[]{new SslServerTlsHandler(url), new HttpRequestDecoder(url.getParameter("max.initial.line.length", 4096), url.getParameter("max.header.size", 8192), url.getParameter("max.chunk.size", 8192)), new HttpObjectAggregator(url.getParameter("max.request.size", 0xA00000)), new HttpResponseEncoder(), new RestHttpRequestDecoder(url, NettyHttpRestServer.this.serviceDeployer)});
            }
        };
    }

    protected Map<ChannelOption, Object> getChildChannelOptionMap(URL url) {
        HashMap<ChannelOption, Object> channelOption = new HashMap<ChannelOption, Object>();
        channelOption.put(ChannelOption.SO_KEEPALIVE, url.getParameter("keepalive", true));
        return channelOption;
    }

    protected Map<ChannelOption, Object> getChannelOptionMap(URL url) {
        HashMap<ChannelOption, Object> options = new HashMap<ChannelOption, Object>();
        options.put(ChannelOption.SO_REUSEADDR, Boolean.TRUE);
        options.put(ChannelOption.TCP_NODELAY, Boolean.TRUE);
        options.put(ChannelOption.SO_BACKLOG, url.getPositiveParameter("backlog", 1024));
        options.put(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return options;
    }

    protected List<ChannelHandler> getChannelHandlers(URL url) {
        ArrayList<ChannelHandler> channelHandlers = new ArrayList<ChannelHandler>();
        return channelHandlers;
    }

    @Override
    public void deploy(ServiceRestMetadata serviceRestMetadata, Invoker invoker) {
        this.serviceDeployer.deploy(serviceRestMetadata, invoker);
    }

    @Override
    public void undeploy(ServiceRestMetadata serviceRestMetadata) {
        this.serviceDeployer.undeploy(serviceRestMetadata);
    }

    private void registerExtension(URL url) {
        this.serviceDeployer.registerExtension(url);
    }
}

