/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.remoting.exchange.Exchangers;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.remoting.exchange.support.ExchangeHandlerAdapter;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.dubbo.ClientsProvider;
import org.apache.dubbo.rpc.protocol.dubbo.DubboExporter;
import org.apache.dubbo.rpc.protocol.dubbo.DubboInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocolServer;
import org.apache.dubbo.rpc.protocol.dubbo.ExclusiveClientsProvider;
import org.apache.dubbo.rpc.protocol.dubbo.LazyConnectExchangeClient;
import org.apache.dubbo.rpc.protocol.dubbo.ReferenceCountExchangeClient;
import org.apache.dubbo.rpc.protocol.dubbo.SharedClientsProvider;

public class DubboProtocol
extends AbstractProtocol {
    public static final String NAME = "dubbo";
    public static final int DEFAULT_PORT = 20880;
    private static final String IS_CALLBACK_SERVICE_INVOKE = "_isCallBackServiceInvoke";
    private final Map<String, SharedClientsProvider> referenceClientMap = new ConcurrentHashMap<String, SharedClientsProvider>();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final ExchangeHandler requestHandler;

    public DubboProtocol(FrameworkModel frameworkModel) {
        this.requestHandler = new ExchangeHandlerAdapter(frameworkModel){

            public CompletableFuture<Object> reply(ExchangeChannel channel, Object message) throws RemotingException {
                Invoker<?> invoker;
                if (!(message instanceof Invocation)) {
                    throw new RemotingException((Channel)channel, "Unsupported request: " + (message == null ? null : message.getClass().getName() + ": " + message) + ", channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress());
                }
                Invocation inv = (Invocation)message;
                Invoker<?> invoker2 = invoker = inv.getInvoker() == null ? DubboProtocol.this.getInvoker((Channel)channel, inv) : inv.getInvoker();
                if (invoker.getUrl().getServiceModel() != null) {
                    Thread.currentThread().setContextClassLoader(invoker.getUrl().getServiceModel().getClassLoader());
                }
                if (Boolean.TRUE.toString().equals(inv.getObjectAttachmentWithoutConvert(DubboProtocol.IS_CALLBACK_SERVICE_INVOKE))) {
                    String methodsStr = (String)invoker.getUrl().getParameters().get("methods");
                    boolean hasMethod = false;
                    if (methodsStr == null || !methodsStr.contains(",")) {
                        hasMethod = inv.getMethodName().equals(methodsStr);
                    } else {
                        String[] methods;
                        for (String method : methods = methodsStr.split(",")) {
                            if (!inv.getMethodName().equals(method)) continue;
                            hasMethod = true;
                            break;
                        }
                    }
                    if (!hasMethod) {
                        DubboProtocol.this.logger.warn("4-3", "", "", new IllegalStateException("The methodName " + inv.getMethodName() + " not found in callback service interface ,invoke will be ignored. please update the api interface. url is:" + invoker.getUrl()) + " ,invocation is :" + inv);
                        return null;
                    }
                }
                RpcContext.getServiceContext().setRemoteAddress(channel.getRemoteAddress());
                Result result = invoker.invoke(inv);
                return result.thenApply(Function.identity());
            }

            public void received(Channel channel, Object message) throws RemotingException {
                if (message instanceof Invocation) {
                    this.reply((ExchangeChannel)channel, message);
                } else {
                    super.received(channel, message);
                }
            }

            public void connected(Channel channel) throws RemotingException {
                this.invoke(channel, "onconnect");
            }

            public void disconnected(Channel channel) throws RemotingException {
                if (DubboProtocol.this.logger.isDebugEnabled()) {
                    DubboProtocol.this.logger.debug("disconnected from " + channel.getRemoteAddress() + ",url:" + channel.getUrl());
                }
                this.invoke(channel, "ondisconnect");
            }

            private void invoke(Channel channel, String methodKey) {
                Invocation invocation = this.createInvocation(channel, channel.getUrl(), methodKey);
                if (invocation != null) {
                    try {
                        if (Boolean.TRUE.toString().equals(invocation.getAttachment("dubbo.stub.event"))) {
                            this.tryToGetStubService(channel, invocation);
                        }
                        this.received(channel, invocation);
                    }
                    catch (Throwable t) {
                        DubboProtocol.this.logger.warn("4-3", "", "", "Failed to invoke event method " + invocation.getMethodName() + "(), cause: " + t.getMessage(), t);
                    }
                }
            }

            private void tryToGetStubService(Channel channel, Invocation invocation) throws RemotingException {
                try {
                    Invoker<?> invoker = DubboProtocol.this.getInvoker(channel, invocation);
                }
                catch (RemotingException e) {
                    String serviceKey = DubboProtocol.serviceKey((int)0, (String)((String)invocation.getObjectAttachmentWithoutConvert("path")), (String)((String)invocation.getObjectAttachmentWithoutConvert("version")), (String)((String)invocation.getObjectAttachmentWithoutConvert("group")));
                    throw new RemotingException(channel, "The stub service[" + serviceKey + "] is not found, it may not be exported yet");
                }
            }

            private Invocation createInvocation(Channel channel, URL url, String methodKey) {
                String method = url.getParameter(methodKey);
                if (method == null || method.length() == 0) {
                    return null;
                }
                RpcInvocation invocation = new RpcInvocation(url.getServiceModel(), method, url.getParameter("interface"), "", new Class[0], new Object[0]);
                invocation.setAttachment("path", url.getPath());
                invocation.setAttachment("group", url.getGroup());
                invocation.setAttachment("interface", url.getParameter("interface"));
                invocation.setAttachment("version", url.getVersion());
                if (url.getParameter("dubbo.stub.event", false)) {
                    invocation.setAttachment("dubbo.stub.event", Boolean.TRUE.toString());
                }
                return invocation;
            }
        };
        this.frameworkModel = frameworkModel;
    }

    @Deprecated
    public static DubboProtocol getDubboProtocol() {
        return (DubboProtocol)((Object)FrameworkModel.defaultModel().getExtensionLoader(Protocol.class).getExtension(NAME, false));
    }

    public static DubboProtocol getDubboProtocol(ScopeModel scopeModel) {
        return (DubboProtocol)((Object)scopeModel.getExtensionLoader(Protocol.class).getExtension(NAME, false));
    }

    private boolean isClientSide(Channel channel) {
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        return url.getPort() == address.getPort() && NetUtils.filterLocalHost((String)channel.getUrl().getIp()).equals(NetUtils.filterLocalHost((String)address.getAddress().getHostAddress()));
    }

    Invoker<?> getInvoker(Channel channel, Invocation inv) throws RemotingException {
        String serviceKey;
        DubboExporter exporter;
        boolean isCallBackServiceInvoke;
        int port = channel.getLocalAddress().getPort();
        String path = (String)inv.getObjectAttachmentWithoutConvert("path");
        boolean isStubServiceInvoke = Boolean.TRUE.toString().equals(inv.getObjectAttachmentWithoutConvert("dubbo.stub.event"));
        if (isStubServiceInvoke) {
            port = 0;
        }
        boolean bl = isCallBackServiceInvoke = this.isClientSide(channel) && !isStubServiceInvoke;
        if (isCallBackServiceInvoke) {
            path = path + "." + inv.getObjectAttachmentWithoutConvert("callback.service.instid");
            inv.setObjectAttachment(IS_CALLBACK_SERVICE_INVOKE, (Object)Boolean.TRUE.toString());
        }
        if ((exporter = (DubboExporter)((Object)this.exporterMap.get(serviceKey = DubboProtocol.serviceKey((int)port, (String)path, (String)((String)inv.getObjectAttachmentWithoutConvert("version")), (String)((String)inv.getObjectAttachmentWithoutConvert("group")))))) == null) {
            throw new RemotingException(channel, "Not found exported service: " + serviceKey + " in " + this.exporterMap.keySet() + ", may be version or group mismatch , channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress() + ", message:" + this.getInvocationWithoutData(inv));
        }
        Invoker invoker = exporter.getInvoker();
        inv.setServiceModel(invoker.getUrl().getServiceModel());
        return invoker;
    }

    public Collection<Invoker<?>> getInvokers() {
        return Collections.unmodifiableCollection(this.invokers);
    }

    public int getDefaultPort() {
        return 20880;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        String stubServiceMethods;
        this.checkDestroyed();
        URL url = invoker.getUrl();
        String key = DubboProtocol.serviceKey((URL)url);
        DubboExporter<T> exporter = new DubboExporter<T>(invoker, key, this.exporterMap);
        boolean isStubSupportEvent = url.getParameter("dubbo.stub.event", false);
        boolean isCallbackService = url.getParameter("is_callback_service", false);
        if (isStubSupportEvent && !isCallbackService && ((stubServiceMethods = url.getParameter("dubbo.stub.event.methods")) == null || stubServiceMethods.length() == 0) && this.logger.isWarnEnabled()) {
            this.logger.warn("4-1", "", "", "consumer [" + url.getParameter("interface") + "], has set stub proxy support event ,but no stub methods founded.");
        }
        this.openServer(url);
        this.optimizeSerialization(url);
        return exporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openServer(URL url) {
        this.checkDestroyed();
        String key = url.getAddress();
        boolean isServer = url.getParameter("isserver", true);
        if (isServer) {
            ProtocolServer server = (ProtocolServer)this.serverMap.get(key);
            if (server == null) {
                DubboProtocol dubboProtocol = this;
                synchronized (dubboProtocol) {
                    server = (ProtocolServer)this.serverMap.get(key);
                    if (server == null) {
                        this.serverMap.put(key, this.createServer(url));
                        return;
                    }
                }
            }
            server.reset(url);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed.get()) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " is destroyed");
        }
    }

    private ProtocolServer createServer(URL url) {
        ExchangeServer server;
        String transporter = (url = URLBuilder.from((URL)url).addParameterIfAbsent("channel.readonly.sent", Boolean.TRUE.toString()).addParameterIfAbsent("heartbeat", String.valueOf(60000)).addParameter("codec", NAME).build()).getParameter("server", "netty");
        if (StringUtils.isNotEmpty((String)transporter) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(transporter)) {
            throw new RpcException("Unsupported server type: " + transporter + ", url: " + url);
        }
        try {
            server = Exchangers.bind((URL)url, (ExchangeHandler)this.requestHandler);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to start server(url: " + url + ") " + e.getMessage(), (Throwable)e);
        }
        transporter = url.getParameter("client");
        if (StringUtils.isNotEmpty((String)transporter) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(transporter)) {
            throw new RpcException("Unsupported client type: " + transporter);
        }
        DubboProtocolServer protocolServer = new DubboProtocolServer((RemotingServer)server);
        this.loadServerProperties(protocolServer);
        return protocolServer;
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.checkDestroyed();
        return this.protocolBindingRefer(type, url);
    }

    public <T> Invoker<T> protocolBindingRefer(Class<T> serviceType, URL url) throws RpcException {
        this.checkDestroyed();
        this.optimizeSerialization(url);
        DubboInvoker<T> invoker = new DubboInvoker<T>(serviceType, url, this.getClients(url), this.invokers);
        this.invokers.add(invoker);
        return invoker;
    }

    private ClientsProvider getClients(URL url) {
        int connections = url.getParameter("connections", 0);
        if (connections == 0) {
            String shareConnectionsStr = StringUtils.isBlank((CharSequence)url.getParameter("shareconnections", (String)null)) ? ConfigurationUtils.getProperty((ScopeModel)url.getOrDefaultApplicationModel(), (String)"shareconnections", (String)"1") : url.getParameter("shareconnections", (String)null);
            connections = Integer.parseInt(shareConnectionsStr);
            return this.getSharedClient(url, connections);
        }
        List<ExchangeClient> clients = IntStream.range(0, connections).mapToObj(i -> this.initClient(url)).collect(Collectors.toList());
        return new ExclusiveClientsProvider(clients);
    }

    private SharedClientsProvider getSharedClient(URL url, int connectNum) {
        String key = url.getAddress();
        int expectedConnectNum = Math.max(connectNum, 1);
        return this.referenceClientMap.compute(key, (originKey, originValue) -> {
            if (originValue != null && originValue.increaseCount()) {
                return originValue;
            }
            return new SharedClientsProvider(this, (String)originKey, this.buildReferenceCountExchangeClientList(url, expectedConnectNum));
        });
    }

    protected void scheduleRemoveSharedClient(String key, SharedClientsProvider sharedClient) {
        ((FrameworkExecutorRepository)this.frameworkModel.getBeanFactory().getBean(FrameworkExecutorRepository.class)).getSharedExecutor().submit(() -> this.referenceClientMap.remove(key, sharedClient));
    }

    private List<ReferenceCountExchangeClient> buildReferenceCountExchangeClientList(URL url, int connectNum) {
        ArrayList<ReferenceCountExchangeClient> clients = new ArrayList<ReferenceCountExchangeClient>();
        for (int i = 0; i < connectNum; ++i) {
            clients.add(this.buildReferenceCountExchangeClient(url));
        }
        return clients;
    }

    private ReferenceCountExchangeClient buildReferenceCountExchangeClient(URL url) {
        ExchangeClient exchangeClient = this.initClient(url);
        ReferenceCountExchangeClient client = new ReferenceCountExchangeClient(exchangeClient, NAME);
        int shutdownTimeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)url.getScopeModel());
        client.setShutdownWaitTime(shutdownTimeout);
        return client;
    }

    private ExchangeClient initClient(URL url) {
        String str = url.getParameter("client", url.getParameter("server", "netty"));
        if (StringUtils.isNotEmpty((String)str) && !url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).hasExtension(str)) {
            throw new RpcException("Unsupported client type: " + str + ", supported client type is " + StringUtils.join((Collection)url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).getSupportedExtensions(), (String)" "));
        }
        try {
            url = new ServiceConfigURL(NAME, url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), url.getAllParameters());
            url = url.addParameter("codec", NAME);
            url = url.addParameterIfAbsent("heartbeat", String.valueOf(60000));
            return url.getParameter("lazy", false) ? new LazyConnectExchangeClient(url, this.requestHandler) : Exchangers.connect((URL)url, (ExchangeHandler)this.requestHandler);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to create remoting client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [" + ((Object)((Object)this)).getClass().getSimpleName() + "] ...");
        }
        for (String key : new ArrayList(this.serverMap.keySet())) {
            ProtocolServer protocolServer = (ProtocolServer)this.serverMap.remove(key);
            if (protocolServer == null) continue;
            RemotingServer server = protocolServer.getRemotingServer();
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing dubbo server: " + server.getLocalAddress());
                }
                server.close(this.getServerShutdownTimeout(protocolServer));
            }
            catch (Throwable t) {
                this.logger.warn("4-8", "", "", "Close dubbo server [" + server.getLocalAddress() + "] failed: " + t.getMessage(), t);
            }
        }
        this.serverMap.clear();
        for (String key : new ArrayList<String>(this.referenceClientMap.keySet())) {
            SharedClientsProvider clients = this.referenceClientMap.remove(key);
            clients.forceClose();
        }
        PortUnificationExchanger.close();
        this.referenceClientMap.clear();
        super.destroy();
    }

    private Invocation getInvocationWithoutData(Invocation invocation) {
        if (this.logger.isDebugEnabled()) {
            return invocation;
        }
        if (invocation instanceof RpcInvocation) {
            RpcInvocation rpcInvocation = (RpcInvocation)invocation;
            rpcInvocation.setArguments(null);
            return rpcInvocation;
        }
        return invocation;
    }
}

