/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpChannelFutureListener;

public class NettyH2StreamChannel
implements H2StreamChannel {
    private final Http2StreamChannel http2StreamChannel;

    public NettyH2StreamChannel(Http2StreamChannel http2StreamChannel) {
        this.http2StreamChannel = http2StreamChannel;
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        NettyHttpChannelFutureListener nettyHttpChannelFutureListener = new NettyHttpChannelFutureListener();
        this.http2StreamChannel.write((Object)httpMetadata).addListener((GenericFutureListener)nettyHttpChannelFutureListener);
        return nettyHttpChannelFutureListener;
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        NettyHttpChannelFutureListener nettyHttpChannelFutureListener = new NettyHttpChannelFutureListener();
        this.http2StreamChannel.write((Object)httpOutputMessage).addListener((GenericFutureListener)nettyHttpChannelFutureListener);
        return nettyHttpChannelFutureListener;
    }

    @Override
    public Http2OutputMessage newOutputMessage(boolean endStream) {
        ByteBuf buffer = this.http2StreamChannel.alloc().buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        return new Http2OutputMessageFrame((OutputStream)outputStream, endStream);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.http2StreamChannel.remoteAddress();
    }

    @Override
    public void flush() {
        this.http2StreamChannel.flush();
    }

    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(errorCode);
        NettyHttpChannelFutureListener nettyHttpChannelFutureListener = new NettyHttpChannelFutureListener();
        this.http2StreamChannel.write((Object)resetFrame).addListener((GenericFutureListener)nettyHttpChannelFutureListener);
        return nettyHttpChannelFutureListener;
    }
}

