/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h1;

import java.io.IOException;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;

public class Http1ServerStreamChannelObserver
extends Http1ServerChannelObserver {
    private static final String SERVER_SENT_EVENT_DATA_PREFIX = "data:";
    private static final String SERVER_SENT_EVENT_LF = "\n\n";
    private static final byte[] SERVER_SENT_EVENT_DATA_PREFIX_BYTES = "data:".getBytes();
    private static final byte[] SERVER_SENT_EVENT_LF_BYTES = "\n\n".getBytes();

    public Http1ServerStreamChannelObserver(HttpChannel httpChannel) {
        super(httpChannel);
    }

    @Override
    protected void preOutputMessage(HttpOutputMessage httpMessage) throws IOException {
        HttpOutputMessage httpOutputMessage = this.getHttpChannel().newOutputMessage();
        httpOutputMessage.getBody().write(SERVER_SENT_EVENT_DATA_PREFIX_BYTES, 0, SERVER_SENT_EVENT_DATA_PREFIX_BYTES.length);
        this.getHttpChannel().writeMessage(httpOutputMessage);
    }

    @Override
    protected void postOutputMessage(HttpOutputMessage httpMessage) throws IOException {
        HttpOutputMessage httpOutputMessage = this.getHttpChannel().newOutputMessage();
        httpOutputMessage.getBody().write(SERVER_SENT_EVENT_LF_BYTES, 0, SERVER_SENT_EVENT_LF_BYTES.length);
        this.getHttpChannel().writeMessage(httpOutputMessage);
    }
}

