/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.pu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractServer;

public abstract class AbstractPortUnificationServer
extends AbstractServer {
    private final List<WireProtocol> protocols;
    private final Map<String, URL> supportedUrls = new ConcurrentHashMap<String, URL>();
    private final Map<String, ChannelHandler> supportedHandlers = new ConcurrentHashMap<String, ChannelHandler>();

    public AbstractPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        ExtensionLoader loader = url.getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class);
        ArrayList<WireProtocol> extProtocols = new ArrayList<WireProtocol>();
        extProtocols.add((WireProtocol)loader.getExtension(url.getProtocol()));
        String extraProtocols = url.getParameter("ext.protocol");
        if (StringUtils.isNotEmpty((String)extraProtocols)) {
            Arrays.stream(extraProtocols.split(",")).forEach(p -> extProtocols.add((WireProtocol)loader.getExtension(p)));
        }
        this.protocols = extProtocols;
    }

    public List<WireProtocol> getProtocols() {
        return this.protocols;
    }

    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        this.supportedUrls.put(url.getProtocol(), url);
        this.supportedHandlers.put(url.getProtocol(), handler);
    }

    protected Map<String, URL> getSupportedUrls() {
        return this.supportedUrls;
    }

    public Map<String, ChannelHandler> getSupportedHandlers() {
        return this.supportedHandlers;
    }
}

