/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.api.ExecutableMode;
import org.apache.dubbo.aot.api.FieldDescriber;
import org.apache.dubbo.aot.api.MemberCategory;
import org.apache.dubbo.aot.api.TypeDescriber;
import org.apache.dubbo.aot.generate.ExecutableDescriber;

public class ReflectConfigMetadataRepository {
    List<TypeDescriber> types = new ArrayList<TypeDescriber>();

    protected ReflectConfigMetadataRepository registerSpiExtensionType(List<Class<?>> classes) {
        this.types.addAll(classes.stream().filter(Objects::nonNull).map(this::buildTypeDescriberWithConstructor).collect(Collectors.toList()));
        return this;
    }

    protected ReflectConfigMetadataRepository registerAdaptiveType(List<Class<?>> classes) {
        this.types.addAll(classes.stream().filter(Objects::nonNull).map(this::buildTypeDescriberWithConstructor).collect(Collectors.toList()));
        return this;
    }

    protected ReflectConfigMetadataRepository registerBeanType(List<Class<?>> classes) {
        this.types.addAll(classes.stream().filter(Objects::nonNull).map(this::buildTypeDescriberWithConstructor).collect(Collectors.toList()));
        return this;
    }

    protected ReflectConfigMetadataRepository registerConfigType(List<Class<?>> classes) {
        this.types.addAll(classes.stream().filter(Objects::nonNull).map(this::buildTypeDescriberWithConstructor).collect(Collectors.toList()));
        return this;
    }

    private TypeDescriber buildTypeDescriberWithConstructor(Class<?> c) {
        Set<ExecutableDescriber> constructors = Arrays.stream(c.getConstructors()).map(constructor -> new ExecutableDescriber((Constructor<?>)constructor, ExecutableMode.INVOKE)).collect(Collectors.toSet());
        HashSet<MemberCategory> memberCategories = new HashSet<MemberCategory>();
        memberCategories.add(MemberCategory.INVOKE_PUBLIC_METHODS);
        return new TypeDescriber(c.getName(), null, new HashSet<FieldDescriber>(), constructors, new HashSet<ExecutableDescriber>(), memberCategories);
    }

    public void registerTypeDescriber(List<TypeDescriber> typeDescribers) {
        this.types.addAll(typeDescribers.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public List<TypeDescriber> getTypes() {
        return this.types;
    }
}

