/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.metadata.MetadataMetricsConstants;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.metrics.metadata.event.MetadataListener;
import org.apache.dubbo.metrics.metadata.type.ApplicationType;
import org.apache.dubbo.metrics.metadata.type.ServiceType;

public final class MetadataMetricsEventMulticaster
extends SimpleMetricsEventMulticaster {
    public MetadataMetricsEventMulticaster() {
        super.addListener((MetricsListener)this.onPostEventBuild(ApplicationType.P_TOTAL));
        super.addListener((MetricsListener)this.onFinishEventBuild(ApplicationType.P_SUCCEED, MetadataMetricsConstants.OP_TYPE_PUSH.getType()));
        super.addListener((MetricsListener)this.onErrorEventBuild(ApplicationType.P_FAILED, MetadataMetricsConstants.OP_TYPE_PUSH.getType()));
        super.addListener((MetricsListener)this.onPostEventBuild(ApplicationType.S_TOTAL));
        super.addListener((MetricsListener)this.onFinishEventBuild(ApplicationType.S_SUCCEED, MetadataMetricsConstants.OP_TYPE_SUBSCRIBE.getType()));
        super.addListener((MetricsListener)this.onErrorEventBuild(ApplicationType.S_FAILED, MetadataMetricsConstants.OP_TYPE_SUBSCRIBE.getType()));
        super.addListener((MetricsListener)MetadataListener.onEvent(ServiceType.S_P_TOTAL, this::incrServiceKey));
        super.addListener((MetricsListener)MetadataListener.onFinish(ServiceType.S_P_SUCCEED, this::incrAndRt));
        super.addListener((MetricsListener)MetadataListener.onError(ServiceType.S_P_FAILED, this::incrAndRt));
    }

    private void incrAndRt(MetadataEvent event, ServiceType type) {
        this.incrServiceKey(event, type);
        event.getCollector().addServiceKeyRT(event.getSource().getApplicationName(), (String)event.getAttachmentValue("serviceKey"), MetadataMetricsConstants.OP_TYPE_STORE_PROVIDER_INTERFACE.getType(), event.getTimePair().calc());
    }

    private void incrServiceKey(MetadataEvent event, ServiceType type) {
        event.getCollector().incrementServiceKey(event.getSource().getApplicationName(), (String)event.getAttachmentValue("serviceKey"), type, 1);
    }

    private MetadataListener onPostEventBuild(ApplicationType applicationType) {
        return MetadataListener.onEvent(applicationType, (event, type) -> event.getCollector().increment(event.getSource().getApplicationName(), (ApplicationType)((Object)type)));
    }

    private MetadataListener onFinishEventBuild(ApplicationType applicationType, String registryOpType) {
        return MetadataListener.onFinish(applicationType, (event, type) -> this.incrAndRt((MetadataEvent)((Object)event), applicationType, registryOpType));
    }

    private MetadataListener onErrorEventBuild(ApplicationType applicationType, String registryOpType) {
        return MetadataListener.onError(applicationType, (event, type) -> this.incrAndRt((MetadataEvent)((Object)event), applicationType, registryOpType));
    }

    private void incrAndRt(MetadataEvent event, ApplicationType applicationType, String registryOpType) {
        event.getCollector().increment(event.getSource().getApplicationName(), applicationType);
        event.getCollector().addApplicationRT(event.getSource().getApplicationName(), registryOpType, event.getTimePair().calc());
    }
}

