/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.ApplicationMetricsCollector;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.metadata.MetadataMetricsConstants;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.metrics.metadata.event.MetadataMetricsEventMulticaster;
import org.apache.dubbo.metrics.metadata.type.ApplicationType;
import org.apache.dubbo.metrics.metadata.type.ServiceType;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsPlaceType;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MetadataMetricsCollector
implements ApplicationMetricsCollector<ApplicationType, MetadataEvent> {
    private Boolean collectEnabled = null;
    private final BaseStatComposite stats = new BaseStatComposite(){

        protected void init(ApplicationStatComposite applicationStatComposite, ServiceStatComposite serviceStatComposite, RtStatComposite rtStatComposite) {
            applicationStatComposite.init(MetadataMetricsConstants.appKeys);
            serviceStatComposite.init(MetadataMetricsConstants.serviceKeys);
            rtStatComposite.init(new MetricsPlaceType[]{MetadataMetricsConstants.OP_TYPE_PUSH, MetadataMetricsConstants.OP_TYPE_SUBSCRIBE, MetadataMetricsConstants.OP_TYPE_STORE_PROVIDER_INTERFACE});
        }
    };
    private final MetricsEventMulticaster metadataEventMulticaster = new MetadataMetricsEventMulticaster();
    private final ApplicationModel applicationModel;

    public MetadataMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableMetadata()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    public void increment(String applicationName, ApplicationType registryType) {
        this.stats.incrementApp(registryType.getMetricsKey(), applicationName, 1);
    }

    public void incrementServiceKey(String applicationName, String serviceKey, ServiceType registryType, int size) {
        this.stats.incrementServiceKey(registryType.getMetricsKey(), applicationName, serviceKey, size);
    }

    public void addApplicationRT(String applicationName, String registryOpType, Long responseTime) {
        this.stats.calcApplicationRt(applicationName, registryOpType, responseTime);
    }

    public void addServiceKeyRT(String applicationName, String serviceKey, String registryOpType, Long responseTime) {
        this.stats.calcServiceKeyRt(applicationName, serviceKey, registryOpType, responseTime);
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(this.stats.export(MetricsCategory.METADATA));
        return list;
    }

    public boolean isSupport(MetricsEvent event) {
        return event instanceof MetadataEvent;
    }

    public void onEvent(MetadataEvent event) {
        this.metadataEventMulticaster.publishEvent((MetricsEvent)event);
    }

    public void onEventFinish(MetadataEvent event) {
        this.metadataEventMulticaster.publishFinishEvent((MetricsEvent)event);
    }

    public void onEventError(MetadataEvent event) {
        this.metadataEventMulticaster.publishErrorEvent((MetricsEvent)event);
    }
}

