/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.util.Objects;

public class PathMatcher {
    private static final String SEPARATOR = "/";
    private String path;
    private String version;
    private String group;
    private Integer port;
    private String[] pathSplits;
    private boolean hasPathVariable;
    private String contextPath;

    public PathMatcher(String path) {
        this(path, null, null, null);
    }

    public PathMatcher(String path, String version, String group, Integer port) {
        this.path = path;
        this.dealPathVariable(path);
        this.version = version;
        this.group = group;
        this.port = port == null || port == -1 || port == 0 ? null : port;
    }

    private void dealPathVariable(String path) {
        for (String pathSplit : this.pathSplits = path.split(SEPARATOR)) {
            if (!this.isPlaceHold(pathSplit)) continue;
            this.hasPathVariable = true;
            break;
        }
    }

    private void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath = this.contextPathFormat(contextPath);
        this.setPath(contextPath + this.path);
        this.dealPathVariable(this.path);
    }

    public static PathMatcher getInvokeCreatePathMatcher(String path, String version, String group, Integer port) {
        return new PathMatcher(path, version, group, port);
    }

    public boolean hasPathVariable() {
        return this.hasPathVariable;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMatcher that = (PathMatcher)o;
        return this.pathEqual(that) && Objects.equals(this.version, that.version) && Objects.equals(this.group, that.group) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.group, this.port);
    }

    private boolean pathEqual(PathMatcher pathMatcher) {
        if (!pathMatcher.hasPathVariable) {
            return this.path.equals(pathMatcher.path);
        }
        String[] thisPathSplits = this.pathSplits;
        String[] pathSplits = pathMatcher.pathSplits;
        if (thisPathSplits.length != pathSplits.length) {
            return false;
        }
        for (int i = 0; i < pathSplits.length; ++i) {
            boolean equals = thisPathSplits[i].equals(pathSplits[i]);
            if (equals || this.placeHoldCompare(pathSplits[i], thisPathSplits[i])) continue;
            return false;
        }
        return true;
    }

    private boolean placeHoldCompare(String pathSplit, String pathToCompare) {
        boolean lengthCondition;
        boolean startAndEndEqual;
        boolean bl = startAndEndEqual = this.isPlaceHold(pathSplit) || this.isPlaceHold(pathToCompare);
        if (!startAndEndEqual) {
            return false;
        }
        boolean bl2 = lengthCondition = pathSplit.length() >= 3 || pathToCompare.length() >= 3;
        return lengthCondition;
    }

    private boolean isPlaceHold(String pathSplit) {
        return pathSplit.startsWith("{") && pathSplit.endsWith("}");
    }

    private String contextPathFormat(String contextPath) {
        if (contextPath == null || contextPath.equals(SEPARATOR) || contextPath.length() == 0) {
            return "";
        }
        return this.pathFormat(contextPath);
    }

    private String pathFormat(String path) {
        if (path.startsWith(SEPARATOR)) {
            return path;
        }
        return SEPARATOR + path;
    }

    public String toString() {
        return "PathMatcher{path='" + this.path + '\'' + ", version='" + this.version + '\'' + ", group='" + this.group + '\'' + ", port=" + this.port + ", hasPathVariable=" + this.hasPathVariable + ", contextPath='" + this.contextPath + '\'' + '}';
    }
}

