/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdMapping;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.filter.Filters;

public class ListFilteredVirtualColumn
implements VirtualColumn {
    private final String name;
    private final DimensionSpec delegate;
    private final Set<String> values;
    private final boolean allowList;

    @JsonCreator
    public ListFilteredVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isAllowList") @Nullable Boolean isAllowList) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.delegate = delegate;
        this.values = values;
        this.allowList = isAllowList == null ? true : isAllowList;
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isAllowList")
    public boolean isAllowList() {
        return this.allowList;
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(2).appendString(this.name).appendCacheable((Cacheable)this.delegate).appendStringsIgnoringOrder(this.values).appendBoolean(this.allowList);
        return builder.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        if (this.allowList) {
            return ListFilteredDimensionSpec.filterAllowList(this.values, factory.makeDimensionSelector(this.delegate));
        }
        return ListFilteredDimensionSpec.filterDenyList(this.values, factory.makeDimensionSelector(this.delegate));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName), factory);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.delegate.getOutputType()).setDictionaryEncoded(true).setHasBitmapIndexes(true);
    }

    @Override
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return inspector.getColumnCapabilities(this.delegate.getDimension());
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.delegate.getDimension());
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, final ColumnSelector columnSelector) {
        return new ColumnIndexSupplier(){

            @Override
            @Nullable
            public <T> T as(Class<T> clazz) {
                ColumnHolder holder = columnSelector.getColumnHolder(ListFilteredVirtualColumn.this.delegate.getDimension());
                if (holder == null) {
                    return null;
                }
                ColumnHolder time = columnSelector.getColumnHolder("__time");
                int numRows = time.getLength();
                ColumnIndexSupplier indexSupplier = holder.getIndexSupplier();
                if (indexSupplier == null) {
                    return null;
                }
                DictionaryEncodedStringValueIndex underlyingIndex = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
                if (underlyingIndex == null) {
                    return null;
                }
                IdMapping idMapping = ListFilteredVirtualColumn.this.allowList ? ListFilteredDimensionSpec.buildAllowListIdMapping(ListFilteredVirtualColumn.this.values, underlyingIndex.getCardinality(), null, underlyingIndex::getValue) : ListFilteredDimensionSpec.buildDenyListIdMapping(ListFilteredVirtualColumn.this.values, underlyingIndex.getCardinality(), underlyingIndex::getValue);
                if (clazz.equals(NullValueIndex.class)) {
                    return (T)new ListFilteredNullValueIndex(underlyingIndex, idMapping, numRows);
                }
                if (clazz.equals(StringValueSetIndex.class)) {
                    return (T)new ListFilteredStringValueSetIndex(underlyingIndex, idMapping);
                }
                if (clazz.equals(DruidPredicateIndex.class)) {
                    return (T)new ListFilteredDruidPredicateIndex(underlyingIndex, idMapping);
                }
                if (clazz.equals(LexicographicalRangeIndex.class)) {
                    return (T)new ListFilteredLexicographicalRangeIndex(underlyingIndex, idMapping);
                }
                if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                    return (T)new ListFilteredDictionaryEncodedStringValueIndex(underlyingIndex, idMapping);
                }
                return null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredVirtualColumn that = (ListFilteredVirtualColumn)o;
        return this.allowList == that.allowList && this.name.equals(that.name) && this.delegate.equals(that.delegate) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate, this.values, this.allowList);
    }

    public String toString() {
        return "ListFilteredVirtualColumn{name='" + this.name + '\'' + ", delegate=" + this.delegate + ", values=" + this.values + ", isAllowList=" + this.allowList + '}';
    }

    private static class ListFilteredDictionaryEncodedStringValueIndex
    extends BaseListFilteredColumnIndex
    implements DictionaryEncodedStringValueIndex {
        private ListFilteredDictionaryEncodedStringValueIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            super(delegate, idMapping);
        }

        @Override
        public int getCardinality() {
            return this.idMapping.getValueCardinality();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            return this.delegate.getValue(this.idMapping.getReverseId(index));
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return this.delegate.getBitmap(this.idMapping.getReverseId(idx));
        }
    }

    private static class ListFilteredLexicographicalRangeIndex
    extends BaseListFilteredColumnIndex
    implements LexicographicalRangeIndex {
        private ListFilteredLexicographicalRangeIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            super(delegate, idMapping);
        }

        @Override
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            return this.forRange(startValue, startStrict, endValue, endStrict, (Predicate<String>)Predicates.alwaysTrue());
        }

        @Override
        public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict, final Predicate<String> matcher) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    int found;
                    int startIndex = startValue == null ? 0 : ((found = this.getReverseIndex(NullHandling.emptyToNullIfNeeded((String)startValue))) >= 0 ? (startStrict ? found + 1 : found) : -(found + 1));
                    int endIndex = endValue == null ? idMapping.getValueCardinality() : ((found = this.getReverseIndex(NullHandling.emptyToNullIfNeeded((String)endValue))) >= 0 ? (endStrict ? found : found + 1) : -(found + 1));
                    endIndex = Math.max(startIndex, endIndex);
                    int start = startIndex;
                    int end = endIndex;
                    return this.getBitmapsInRange((Predicate<String>)matcher, start, end);
                }
            };
        }
    }

    private static class ListFilteredDruidPredicateIndex
    extends BaseListFilteredColumnIndex
    implements DruidPredicateIndex {
        private ListFilteredDruidPredicateIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            super(delegate, idMapping);
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    boolean start = false;
                    int end = this.getCardinality();
                    return Filters.estimateSelectivity(this.getBitmapsInRange(matcherFactory.makeStringPredicate(), 0, end).iterator(), totalRows);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    boolean start = false;
                    int end = this.getCardinality();
                    return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapsInRange(matcherFactory.makeStringPredicate(), 0, end));
                }
            };
        }
    }

    private static class ListFilteredStringValueSetIndex
    extends BaseListFilteredColumnIndex
    implements StringValueSetIndex {
        private ListFilteredStringValueSetIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            super(delegate, idMapping);
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    return Math.min(1.0, (double)this.getBitmapForValue().size() / (double)totalRows);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
                }

                private ImmutableBitmap getBitmapForValue() {
                    int reverseIndex = this.getReverseIndex(value);
                    if (reverseIndex < 0) {
                        return delegate.getBitmap(-1);
                    }
                    return delegate.getBitmap(idMapping.getReverseId(reverseIndex));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        final Iterator iterator;
                        {
                            this.iterator = values.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.next = this.getReverseIndex(nextValue);
                            }
                        }
                    };
                }
            };
        }
    }

    private static class ListFilteredNullValueIndex
    extends BaseListFilteredColumnIndex
    implements NullValueIndex {
        private final int numRows;

        private ListFilteredNullValueIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping, int numRows) {
            super(delegate, idMapping);
            this.numRows = numRows;
        }

        @Override
        public BitmapColumnIndex forNull() {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    return 1.0 - Filters.estimateSelectivity(this.getBitmapIterable().iterator(), totalRows);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    return bitmapResultFactory.complement(bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable()), numRows);
                }

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable() {
                    int start = NullHandling.isNullOrEquivalent((String)delegate.getValue(idMapping.getReverseId(0))) ? 1 : 0;
                    return this.getBitmapsInRange((Predicate<String>)((Predicate)v -> true), start, idMapping.getValueCardinality());
                }
            };
        }
    }

    private static class BaseListFilteredColumnIndex {
        final DictionaryEncodedStringValueIndex delegate;
        final IdMapping idMapping;

        private BaseListFilteredColumnIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            this.delegate = delegate;
            this.idMapping = idMapping;
        }

        ImmutableBitmap getBitmap(int idx) {
            return this.delegate.getBitmap(this.idMapping.getReverseId(idx));
        }

        int getCardinality() {
            return this.idMapping.getValueCardinality();
        }

        int getReverseIndex(@Nullable String value) {
            int minIndex = 0;
            int maxIndex = this.idMapping.getValueCardinality() - 1;
            StringComparator comparator = StringComparators.LEXICOGRAPHIC;
            while (minIndex <= maxIndex) {
                int currIndex = minIndex + maxIndex >>> 1;
                String currValue = this.delegate.getValue(this.idMapping.getReverseId(currIndex));
                int comparison = comparator.compare(currValue, value);
                if (comparison == 0) {
                    return currIndex;
                }
                if (comparison < 0) {
                    minIndex = currIndex + 1;
                    continue;
                }
                maxIndex = currIndex - 1;
            }
            return -(minIndex + 1);
        }

        Iterable<ImmutableBitmap> getBitmapsInRange(final Predicate<String> matcher, final int start, final int end) {
            return () -> new Iterator<ImmutableBitmap>(){
                int currIndex;
                int found;
                {
                    this.currIndex = start;
                    this.found = this.findNext();
                }

                private int findNext() {
                    while (this.currIndex < end && !matcher.apply((Object)delegate.getValue(idMapping.getReverseId(this.currIndex)))) {
                        ++this.currIndex;
                    }
                    if (this.currIndex < end) {
                        return this.currIndex++;
                    }
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return this.found != -1;
                }

                @Override
                public ImmutableBitmap next() {
                    int cur = this.found;
                    if (cur == -1) {
                        throw new NoSuchElementException();
                    }
                    this.found = this.findNext();
                    return this.getBitmap(cur);
                }
            };
        }
    }
}

