/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.nested.StructuredData;

public abstract class StructuredDataProcessor {
    public static final String ROOT_LITERAL = ".";
    private static final Set<String> ROOT_LITERAL_FIELDS = ImmutableSet.of((Object)".");

    public abstract int processLiteralField(String var1, Object var2);

    public ProcessResults processFields(Object raw) {
        ArrayDeque<Field> toProcess = new ArrayDeque<Field>();
        if ((raw = StructuredData.unwrap(raw)) instanceof Map) {
            toProcess.add(new MapField("", (Map)raw));
        } else if (raw instanceof List) {
            toProcess.add(new ListField(ROOT_LITERAL, (List)raw));
        } else {
            return new ProcessResults().withFields(ROOT_LITERAL_FIELDS).withSize(this.processLiteralField(ROOT_LITERAL, raw));
        }
        ProcessResults accumulator = new ProcessResults();
        while (!toProcess.isEmpty()) {
            Field next = (Field)toProcess.poll();
            if (next instanceof MapField) {
                accumulator.merge(this.processMapField(toProcess, (MapField)next));
                continue;
            }
            if (!(next instanceof ListField)) continue;
            accumulator.merge(this.processListField(toProcess, (ListField)next));
        }
        return accumulator;
    }

    private ProcessResults processMapField(Queue<Field> toProcess, MapField map) {
        ProcessResults processResults = new ProcessResults().withSize(16);
        for (Map.Entry<String, ?> entry : map.getMap().entrySet()) {
            processResults.addSize(StructuredDataProcessor.estimateStringSize(entry.getKey()));
            String fieldName = map.getName() + ".\"" + entry.getKey() + "\"";
            Object value = StructuredData.unwrap(entry.getValue());
            if (value instanceof List) {
                List theList = (List)value;
                toProcess.add(new ListField(fieldName, theList));
                continue;
            }
            if (value instanceof Map) {
                toProcess.add(new MapField(fieldName, (Map)value));
                continue;
            }
            processResults.addLiteralField(fieldName, this.processLiteralField(fieldName, value));
        }
        return processResults;
    }

    private ProcessResults processListField(Queue<Field> toProcess, ListField list) {
        ProcessResults results = new ProcessResults().withSize(8);
        List<?> theList = list.getList();
        for (int i = 0; i < theList.size(); ++i) {
            String listFieldName = list.getName() + "[" + i + "]";
            Object element = StructuredData.unwrap(theList.get(i));
            if (element instanceof Map) {
                toProcess.add(new MapField(listFieldName, (Map)element));
                continue;
            }
            if (element instanceof List) {
                toProcess.add(new ListField(listFieldName, (List)element));
                continue;
            }
            results.addLiteralField(listFieldName, this.processLiteralField(listFieldName, element));
        }
        return results;
    }

    public static int estimateStringSize(@Nullable String value) {
        return value == null ? 0 : 44 + 2 * value.length();
    }

    public static int getLongObjectEstimateSize() {
        return 16;
    }

    public static int getDoubleObjectEstimateSize() {
        return 16;
    }

    public static class ProcessResults {
        private Set<String> literalFields = new HashSet<String>();
        private int estimatedSize = 0;

        public Set<String> getLiteralFields() {
            return this.literalFields;
        }

        public int getEstimatedSize() {
            return this.estimatedSize;
        }

        public ProcessResults addSize(int size) {
            this.estimatedSize += size;
            return this;
        }

        public ProcessResults addLiteralField(String fieldName, int sizeOfValue) {
            this.literalFields.add(fieldName);
            this.estimatedSize += sizeOfValue;
            return this;
        }

        public ProcessResults withFields(Set<String> fields) {
            this.literalFields = fields;
            return this;
        }

        public ProcessResults withSize(int size) {
            this.estimatedSize = size;
            return this;
        }

        public ProcessResults merge(ProcessResults other) {
            this.literalFields.addAll(other.literalFields);
            this.estimatedSize += other.estimatedSize;
            return this;
        }
    }

    static class MapField
    extends Field {
        private final Map<String, ?> map;

        MapField(String name, Map<String, ?> map) {
            super(name);
            this.map = map;
        }

        public Map<String, ?> getMap() {
            return this.map;
        }
    }

    static class ListField
    extends Field {
        private final List<?> list;

        ListField(String name, List<?> list) {
            super(name);
            this.list = list;
        }

        public List<?> getList() {
            return this.list;
        }
    }

    static abstract class Field {
        private final String name;

        protected Field(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

