/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.NumericRangeIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;

public class NestedFieldLiteralColumnIndexSupplier
implements ColumnIndexSupplier {
    @Nullable
    private final ColumnType singleType;
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final FixedIndexed<Integer> dictionary;
    private final GenericIndexed<String> globalDictionary;
    private final FixedIndexed<Long> globalLongDictionary;
    private final FixedIndexed<Double> globalDoubleDictionary;
    private final int adjustLongId;
    private final int adjustDoubleId;

    public NestedFieldLiteralColumnIndexSupplier(NestedLiteralTypeInfo.TypeSet types, BitmapFactory bitmapFactory, GenericIndexed<ImmutableBitmap> bitmaps, FixedIndexed<Integer> dictionary, GenericIndexed<String> globalDictionary, FixedIndexed<Long> globalLongDictionary, FixedIndexed<Double> globalDoubleDictionary) {
        this.singleType = types.getSingleType();
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.dictionary = dictionary;
        this.globalDictionary = globalDictionary;
        this.globalLongDictionary = globalLongDictionary;
        this.globalDoubleDictionary = globalDoubleDictionary;
        this.adjustLongId = globalDictionary.size();
        this.adjustDoubleId = this.adjustLongId + globalLongDictionary.size();
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = this.dictionary.get(0) == 0 ? new SimpleImmutableBitmapIndex(this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new NestedLiteralDictionaryEncodedStringValueIndex();
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case STRING: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedStringLiteralValueSetIndex();
                    }
                    if (clazz.equals(LexicographicalRangeIndex.class)) {
                        return (T)new NestedStringLiteralLexicographicalRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedStringLiteralPredicateIndex();
                    }
                    return null;
                }
                case LONG: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedLongLiteralValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndex.class)) {
                        return (T)new NestedLongLiteralNumericRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedLongLiteralPredicateIndex();
                    }
                    return null;
                }
                case DOUBLE: {
                    if (clazz.equals(StringValueSetIndex.class)) {
                        return (T)new NestedDoubleLiteralValueSetIndex();
                    }
                    if (clazz.equals(NumericRangeIndex.class)) {
                        return (T)new NestedDoubleLiteralNumericRangeIndex();
                    }
                    if (clazz.equals(DruidPredicateIndex.class)) {
                        return (T)new NestedDoubleLiteralPredicateIndex();
                    }
                    return null;
                }
            }
            return null;
        }
        if (clazz.equals(StringValueSetIndex.class)) {
            return (T)new NestedVariantLiteralValueSetIndex();
        }
        if (clazz.equals(DruidPredicateIndex.class)) {
            return (T)new NestedVariantLiteralPredicateIndex();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private <T> IntIntPair getLocalRangeFromDictionary(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, Indexed<T> globalDictionary, int adjust) {
        int found;
        int globalStartIndex = startValue == null ? (adjust == 0 ? 1 : adjust) : ((found = globalDictionary.indexOf(startValue)) >= 0 ? adjust + (startStrict ? found + 1 : found) : adjust + -(found + 1));
        int globalEndIndex = endValue == null ? globalDictionary.size() + adjust : ((found = globalDictionary.indexOf(endValue)) >= 0 ? adjust + (endStrict ? found : found + 1) : adjust + -(found + 1));
        if (globalStartIndex == (globalEndIndex = Math.max(globalStartIndex, globalEndIndex))) {
            return new IntIntImmutablePair(0, 0);
        }
        int localFound = this.dictionary.indexOf(globalStartIndex);
        int localStartIndex = localFound < 0 ? -(localFound + 1) : localFound;
        int localEndFound = this.dictionary.indexOf(globalEndIndex);
        int localEndIndex = localEndFound < 0 ? -localEndFound : localEndFound;
        localStartIndex = Math.min(localStartIndex, this.dictionary.size());
        localEndIndex = Math.max(localStartIndex, Math.min(this.dictionary.size(), localEndIndex));
        return new IntIntImmutablePair(localStartIndex, localEndIndex);
    }

    private <T> BitmapColumnIndex makeRangeIndex(@Nullable T startValue, boolean startStrict, @Nullable T endValue, boolean endStrict, Indexed<T> globalDictionary, int adjust) {
        IntIntPair localRange = this.getLocalRangeFromDictionary(startValue, startStrict, endValue, endStrict, globalDictionary, adjust);
        final int startIndex = localRange.leftInt();
        final int endIndex = localRange.rightInt();
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final IntIterator rangeIterator;
                    {
                        this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rangeIterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                    }
                };
            }
        };
    }

    private class NestedVariantLiteralPredicateIndex
    extends NestedVariantLiteralIndex
    implements DruidPredicateIndex {
        private NestedVariantLiteralPredicateIndex() {
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidLongPredicate longPredicate;
                        final DruidDoublePredicate doublePredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final Predicate stringPredicate;
                        final Iterator iterator;
                        {
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.iterator = NestedFieldLiteralColumnIndexSupplier.this.dictionary.iterator();
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue >= NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId ? this.doublePredicate.applyDouble((Double)NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.get(nextValue - NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId)) : (nextValue >= NestedFieldLiteralColumnIndexSupplier.this.adjustLongId ? this.longPredicate.applyLong((Long)NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.get(nextValue - NestedFieldLiteralColumnIndexSupplier.this.adjustLongId)) : this.stringPredicate.apply(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.get(nextValue)));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedVariantLiteralValueSetIndex
    extends NestedVariantLiteralIndex
    implements StringValueSetIndex {
        private NestedVariantLiteralValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntListIterator iterator = NestedVariantLiteralValueSetIndex.this.getIndexes(value).iterator();
                    return () -> this.lambda$getBitmapIterable$0((IntIterator)iterator);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final IntIterator iterator) {
                    return new Iterator<ImmutableBitmap>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(iterator.nextInt());
                        }
                    };
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        IntIterator nextIterator;
                        final Iterator iterator;
                        {
                            this.iterator = values.iterator();
                            this.nextIterator = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                            }
                            return this.nextIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.nextIterator == null || !this.nextIterator.hasNext()) {
                                this.findNext();
                                if (!this.nextIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                            }
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.nextIterator.nextInt());
                        }

                        private void findNext() {
                            while ((this.nextIterator == null || !this.nextIterator.hasNext()) && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.nextIterator = NestedVariantLiteralValueSetIndex.this.getIndexes(nextValue).iterator();
                            }
                        }
                    };
                }
            };
        }
    }

    private abstract class NestedVariantLiteralIndex {
        private NestedVariantLiteralIndex() {
        }

        IntList getIndexes(@Nullable String value) {
            Double someDouble;
            Long someLong;
            IntArrayList intList = new IntArrayList();
            if (value == null) {
                intList.add(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(0));
                return intList;
            }
            int globalId = NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.indexOf(value);
            int localId = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(globalId);
            if (localId >= 0) {
                intList.add(localId);
            }
            if ((someLong = GuavaUtils.tryParseLong((String)value)) != null) {
                globalId = NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.indexOf(someLong);
                localId = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(globalId + NestedFieldLiteralColumnIndexSupplier.this.adjustLongId);
                if (localId >= 0) {
                    intList.add(localId);
                }
            }
            if ((someDouble = Doubles.tryParse((String)value)) != null) {
                globalId = NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.indexOf(someDouble);
                localId = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(globalId + NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId);
                if (localId >= 0) {
                    intList.add(localId);
                }
            }
            return intList;
        }
    }

    private class NestedDoubleLiteralPredicateIndex
    implements DruidPredicateIndex {
        private NestedDoubleLiteralPredicateIndex() {
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidDoublePredicate doublePredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final Iterator iterator;
                        {
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.iterator = NestedFieldLiteralColumnIndexSupplier.this.dictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue == 0 ? this.doublePredicate.applyNull() : this.doublePredicate.applyDouble((Double)NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.get(nextValue - NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedDoubleLiteralNumericRangeIndex
    implements NumericRangeIndex {
        private NestedDoubleLiteralNumericRangeIndex() {
        }

        @Override
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            return NestedFieldLiteralColumnIndexSupplier.this.makeRangeIndex(startValue != null ? Double.valueOf(startValue.doubleValue()) : null, startStrict, endValue != null ? Double.valueOf(endValue.doubleValue()) : null, endStrict, NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary, NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId);
        }
    }

    private class NestedDoubleLiteralValueSetIndex
    implements StringValueSetIndex {
        private NestedDoubleLiteralValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final Double doubleValue = Strings.isNullOrEmpty((String)value) ? null : Doubles.tryParse((String)value);
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    if (doubleValue == null) {
                        return (double)NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(0)).size() / (double)totalRows;
                    }
                    return (double)NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.indexOf(doubleValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId)).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    if (doubleValue == null) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(0)));
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.indexOf(doubleValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    DoubleArraySet doubles = new DoubleArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Double theValue = Doubles.tryParse((String)value);
                        if (theValue == null) continue;
                        doubles.add(theValue.doubleValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((DoubleSet)doubles, doNullCheck);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final DoubleSet doubles, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final DoubleIterator iterator;
                        int next;
                        boolean nullChecked;
                        {
                            this.iterator = doubles.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                double nextValue = this.iterator.nextDouble();
                                this.next = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.indexOf(nextValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongLiteralPredicateIndex
    implements DruidPredicateIndex {
        private NestedLongLiteralPredicateIndex() {
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidLongPredicate longPredicate;
                        int next;
                        int index;
                        boolean nextSet;
                        final Iterator iterator;
                        {
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.iterator = NestedFieldLiteralColumnIndexSupplier.this.dictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = nextValue == 0 ? this.longPredicate.applyNull() : this.longPredicate.applyLong((Long)NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.get(nextValue - NestedFieldLiteralColumnIndexSupplier.this.adjustLongId));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLongLiteralNumericRangeIndex
    implements NumericRangeIndex {
        private NestedLongLiteralNumericRangeIndex() {
        }

        @Override
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            return NestedFieldLiteralColumnIndexSupplier.this.makeRangeIndex(startValue != null ? Long.valueOf(startValue.longValue()) : null, startStrict, endValue != null ? Long.valueOf(endValue.longValue()) : null, endStrict, NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary, NestedFieldLiteralColumnIndexSupplier.this.adjustLongId);
        }
    }

    private class NestedLongLiteralValueSetIndex
    implements StringValueSetIndex {
        private NestedLongLiteralValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final Long longValue = GuavaUtils.tryParseLong((String)value);
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    if (longValue == null) {
                        return (double)NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(0)).size() / (double)totalRows;
                    }
                    return (double)NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.indexOf(longValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustLongId)).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    if (longValue == null) {
                        return bitmapResultFactory.wrapDimensionValue(NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(0)));
                    }
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.indexOf(longValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustLongId)));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    LongArraySet longs = new LongArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Long theValue = GuavaUtils.tryParseLong((String)value);
                        if (theValue == null) continue;
                        longs.add(theValue.longValue());
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((LongSet)longs, doNullCheck);
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final LongSet longs, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final LongIterator iterator;
                        int next;
                        boolean nullChecked;
                        {
                            this.iterator = longs.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                long nextValue = this.iterator.nextLong();
                                this.next = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.indexOf(nextValue) + NestedFieldLiteralColumnIndexSupplier.this.adjustLongId);
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedStringLiteralPredicateIndex
    implements DruidPredicateIndex {
        private NestedStringLiteralPredicateIndex() {
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        int index;
                        boolean nextSet;
                        final Predicate stringPredicate;
                        final Iterator iterator;
                        {
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.iterator = NestedFieldLiteralColumnIndexSupplier.this.dictionary.iterator();
                            this.index = 0;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(this.next);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Integer nextValue = (Integer)this.iterator.next();
                                this.nextSet = this.stringPredicate.apply(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.get(nextValue));
                                if (this.nextSet) {
                                    this.next = this.index;
                                }
                                ++this.index;
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedStringLiteralLexicographicalRangeIndex
    implements LexicographicalRangeIndex {
        private NestedStringLiteralLexicographicalRangeIndex() {
        }

        @Override
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            return NestedFieldLiteralColumnIndexSupplier.this.makeRangeIndex(NullHandling.emptyToNullIfNeeded((String)startValue), startStrict, NullHandling.emptyToNullIfNeeded((String)endValue), endStrict, NestedFieldLiteralColumnIndexSupplier.this.globalDictionary, 0);
        }

        @Override
        public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict, final Predicate<String> matcher) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntIntPair range = NestedFieldLiteralColumnIndexSupplier.this.getLocalRangeFromDictionary(startValue, startStrict, endValue, endStrict, NestedFieldLiteralColumnIndexSupplier.this.globalDictionary, 0);
                    final int start = range.leftInt();
                    final int end = range.rightInt();
                    return () -> new Iterator<ImmutableBitmap>(){
                        int currIndex;
                        int found;
                        {
                            this.currIndex = start;
                            this.found = this.findNext();
                        }

                        private int findNext() {
                            while (this.currIndex < end && !matcher.apply(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.get((Integer)NestedFieldLiteralColumnIndexSupplier.this.dictionary.get(this.currIndex)))) {
                                ++this.currIndex;
                            }
                            if (this.currIndex < end) {
                                return this.currIndex++;
                            }
                            return -1;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.found != -1;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            int cur = this.found;
                            if (cur == -1) {
                                throw new NoSuchElementException();
                            }
                            this.found = this.findNext();
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(cur);
                        }
                    };
                }
            };
        }
    }

    private class NestedStringLiteralValueSetIndex
    implements StringValueSetIndex {
        private NestedStringLiteralValueSetIndex() {
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    return (double)NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.indexOf(value))).size() / (double)totalRows;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    return bitmapResultFactory.wrapDimensionValue(NestedFieldLiteralColumnIndexSupplier.this.getBitmap(NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.indexOf(value))));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        final Iterator iterator;
                        {
                            this.iterator = values.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.next = NestedFieldLiteralColumnIndexSupplier.this.dictionary.indexOf(NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.indexOf(nextValue));
                            }
                        }
                    };
                }
            };
        }
    }

    private class NestedLiteralDictionaryEncodedStringValueIndex
    implements DictionaryEncodedStringValueIndex {
        private NestedLiteralDictionaryEncodedStringValueIndex() {
        }

        @Override
        public int getCardinality() {
            return NestedFieldLiteralColumnIndexSupplier.this.dictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            int globalIndex = (Integer)NestedFieldLiteralColumnIndexSupplier.this.dictionary.get(index);
            if (globalIndex < NestedFieldLiteralColumnIndexSupplier.this.adjustLongId) {
                return (String)NestedFieldLiteralColumnIndexSupplier.this.globalDictionary.get(globalIndex);
            }
            if (globalIndex < NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId) {
                return String.valueOf(NestedFieldLiteralColumnIndexSupplier.this.globalLongDictionary.get(globalIndex - NestedFieldLiteralColumnIndexSupplier.this.adjustLongId));
            }
            return String.valueOf(NestedFieldLiteralColumnIndexSupplier.this.globalDoubleDictionary.get(globalIndex - NestedFieldLiteralColumnIndexSupplier.this.adjustDoubleId));
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return NestedFieldLiteralColumnIndexSupplier.this.getBitmap(idx);
        }
    }
}

