/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;
import org.apache.druid.segment.join.table.IndexedTableDimensionSelector;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;

public class IndexedTableJoinable
implements Joinable {
    private final IndexedTable table;

    public IndexedTableJoinable(IndexedTable table) {
        this.table = table;
    }

    @Override
    public List<String> getAvailableColumns() {
        return this.table.rowSignature().getColumnNames();
    }

    @Override
    public int getCardinality(String columnName) {
        if (this.table.rowSignature().contains(columnName)) {
            return IndexedTableDimensionSelector.computeDimensionSelectorCardinality(this.table);
        }
        return 1;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return IndexedTableColumnSelectorFactory.columnCapabilities(this.table, columnName);
    }

    @Override
    public JoinMatcher makeJoinMatcher(ColumnSelectorFactory leftColumnSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, boolean descending, Closer closer) {
        return new IndexedTableJoinMatcher(this.table, leftColumnSelectorFactory, condition, remainderNeeded, descending, closer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Joinable.ColumnValuesWithUniqueFlag getNonNullColumnValues(String columnName, int maxNumValues) {
        int columnPosition = this.table.rowSignature().indexOf(columnName);
        if (columnPosition < 0) {
            return new Joinable.ColumnValuesWithUniqueFlag((Set<String>)ImmutableSet.of(), false);
        }
        try (IndexedTable.Reader reader = this.table.columnReader(columnPosition);){
            Set<String> allValues = IndexedTableJoinable.createValuesSet();
            boolean allUnique = true;
            for (int i = 0; i < this.table.numRows(); ++i) {
                String s = DimensionHandlerUtils.convertObjectToString(reader.read(i));
                if (NullHandling.isNullOrEquivalent((String)s)) continue;
                if (!allValues.add(s)) {
                    allUnique = false;
                }
                if (allValues.size() <= maxNumValues) continue;
                Joinable.ColumnValuesWithUniqueFlag columnValuesWithUniqueFlag = new Joinable.ColumnValuesWithUniqueFlag((Set<String>)ImmutableSet.of(), false);
                return columnValuesWithUniqueFlag;
            }
            Joinable.ColumnValuesWithUniqueFlag columnValuesWithUniqueFlag = new Joinable.ColumnValuesWithUniqueFlag(allValues, allUnique);
            return columnValuesWithUniqueFlag;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Set<String>> getCorrelatedColumnValues(String searchColumnName, String searchColumnValue, String retrievalColumnName, long maxCorrelationSetSize, boolean allowNonKeyColumnSearch) {
        int i;
        IntList rowIndex;
        IndexedTable.Reader reader;
        Set<String> correlatedValues;
        int filterColumnPosition = this.table.rowSignature().indexOf(searchColumnName);
        int correlatedColumnPosition = this.table.rowSignature().indexOf(retrievalColumnName);
        if (filterColumnPosition < 0) return Optional.empty();
        if (correlatedColumnPosition < 0) {
            return Optional.empty();
        }
        try (Closer closer = Closer.create();){
            correlatedValues = IndexedTableJoinable.createValuesSet();
            if (!this.table.keyColumns().contains(searchColumnName)) {
                if (!allowNonKeyColumnSearch) {
                    Optional<Set<String>> index = Optional.empty();
                    return index;
                }
                IndexedTable.Reader dimNameReader = this.table.columnReader(filterColumnPosition);
                IndexedTable.Reader correlatedColumnReader = this.table.columnReader(correlatedColumnPosition);
                closer.register((Closeable)dimNameReader);
                closer.register((Closeable)correlatedColumnReader);
                for (int i2 = 0; i2 < this.table.numRows(); ++i2) {
                    String dimVal = Objects.toString(dimNameReader.read(i2), null);
                    if (!searchColumnValue.equals(dimVal)) continue;
                    String correlatedDimVal = DimensionHandlerUtils.convertObjectToString(correlatedColumnReader.read(i2));
                    correlatedValues.add(correlatedDimVal);
                    if ((long)correlatedValues.size() <= maxCorrelationSetSize) continue;
                    Optional<Set<String>> optional = Optional.empty();
                    return optional;
                }
                Optional<Set<String>> optional = Optional.of(correlatedValues);
                return optional;
            }
            IndexedTable.Index index = this.table.columnIndex(filterColumnPosition);
            reader = this.table.columnReader(correlatedColumnPosition);
            closer.register((Closeable)reader);
            rowIndex = index.find(searchColumnValue);
            i = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (i < rowIndex.size()) {
            int rowNum = rowIndex.getInt(i);
            String correlatedDimVal = DimensionHandlerUtils.convertObjectToString(reader.read(rowNum));
            correlatedValues.add(correlatedDimVal);
            if ((long)correlatedValues.size() > maxCorrelationSetSize) {
                return Optional.empty();
            }
            ++i;
        }
        return Optional.of(correlatedValues);
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return this.table.acquireReferences();
    }

    private static Set<String> createValuesSet() {
        return new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
    }
}

